/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ScaledImageComponent
extends JComponent {
    private BufferedImage image;
    private boolean imageEnlargementEnabled;

    public ScaledImageComponent() {
        this(null);
    }

    public ScaledImageComponent(BufferedImage bufferedImage) {
        this(bufferedImage, false);
    }

    public ScaledImageComponent(BufferedImage bufferedImage, boolean bl) {
        this.image = bufferedImage;
        this.imageEnlargementEnabled = bl;
        this.setBorder(BorderFactory.createEtchedBorder(1));
    }

    public Dimension getPreferredSize() {
        float f;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        if (this.image == null) {
            return new Dimension(300 + insets.left + insets.right, 300 + insets.top + insets.bottom);
        }
        int n = 300 - insets.left - insets.right;
        int n2 = 300 - insets.top - insets.bottom;
        float f2 = (float)this.image.getWidth() / (float)n;
        if (f2 > (f = (float)this.image.getHeight() / (float)n2)) {
            return new Dimension(300, (int)((float)this.image.getHeight() / f2) + insets.top + insets.bottom);
        }
        return new Dimension((int)((float)this.image.getWidth() / f) + insets.left + insets.right, 300);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paintImage(graphics, null);
    }

    protected void paintImage(Graphics graphics, AlphaComposite alphaComposite) {
        if (this.image != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform affineTransform = graphics2D.getTransform();
            Composite composite = graphics2D.getComposite();
            Point point = this.getImageTranslation();
            graphics2D.translate(point.x, point.y);
            float f = this.getImageScale();
            graphics2D.scale(f, f);
            if (alphaComposite != null) {
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.drawImage((Image)this.image, 0, 0, this);
            graphics2D.setComposite(composite);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    protected float getImageScale() {
        if (this.image != null) {
            Insets insets = this.getInsets();
            float f = Math.min((float)(this.getWidth() - insets.left - insets.right) / (float)this.image.getWidth(), (float)(this.getHeight() - insets.top - insets.bottom) / (float)this.image.getHeight());
            if (this.imageEnlargementEnabled) {
                return f;
            }
            return Math.min(1.0f, f);
        }
        return 1.0f;
    }

    protected Point getImageTranslation() {
        float f = this.getImageScale();
        Insets insets = this.getInsets();
        return new Point(insets.left + (this.getWidth() - insets.left - insets.right - Math.round((float)this.image.getWidth() * f)) / 2, insets.top + (this.getHeight() - insets.top - insets.bottom - Math.round((float)this.image.getHeight() * f)) / 2);
    }

    protected boolean isPointInImage(int n, int n2) {
        Point point = this.getImageTranslation();
        float f = this.getImageScale();
        return n > point.x && n < point.x + Math.round((float)this.getImage().getWidth() * f) && n2 > point.y && n2 < point.y + Math.round((float)this.getImage().getHeight() * f);
    }
}

