/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.UserPreferencesController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserPreferencesPanel
extends JPanel
implements DialogView {
    private final UserPreferencesController controller;
    private JLabel languageLabel;
    private JComboBox languageComboBox;
    private JLabel unitLabel;
    private JRadioButton centimeterRadioButton;
    private JRadioButton inchRadioButton;
    private JRadioButton millimeterRadioButton;
    private JRadioButton meterRadioButton;
    private JLabel furnitureCatalogViewLabel;
    private JRadioButton treeRadioButton;
    private JRadioButton listRadioButton;
    private JLabel navigationPanelLabel;
    private JCheckBox navigationPanelCheckBox;
    private JLabel magnetismLabel;
    private JCheckBox magnetismCheckBox;
    private JLabel rulersLabel;
    private JCheckBox rulersCheckBox;
    private JLabel gridLabel;
    private JCheckBox gridCheckBox;
    private JLabel furnitureIconLabel;
    private JRadioButton catalogIconRadioButton;
    private JRadioButton topViewRadioButton;
    private JLabel roomRenderingLabel;
    private JRadioButton monochromeRadioButton;
    private JRadioButton floorColorOrTextureRadioButton;
    private JLabel wallPatternLabel;
    private JComboBox wallPatternComboBox;
    private JLabel newWallThicknessLabel;
    private JSpinner newWallThicknessSpinner;
    private JLabel newWallHeightLabel;
    private JSpinner newWallHeightSpinner;
    private JCheckBox autoSaveDelayForRecoveryCheckBox;
    private JSpinner autoSaveDelayForRecoverySpinner;
    private JLabel autoSaveDelayForRecoveryUnitLabel;
    private JButton resetDisplayedActionTipsButton;
    private String dialogTitle;

    public UserPreferencesPanel(UserPreferences userPreferences, UserPreferencesController userPreferencesController) {
        super(new GridBagLayout());
        this.controller = userPreferencesController;
        this.createComponents(userPreferences, userPreferencesController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(UserPreferences userPreferences, final UserPreferencesController userPreferencesController) {
        EventListener eventListener;
        Object object;
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.LANGUAGE)) {
            this.languageLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "languageLabel.text", new Object[0]));
            this.languageComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(userPreferences.getSupportedLanguages()));
            this.languageComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = (String)object;
                    int n2 = string.indexOf("_");
                    Locale locale = n2 != -1 ? new Locale(string.substring(0, n2), string.substring(n2 + 1)) : new Locale(string);
                    String string2 = locale.getDisplayLanguage(locale);
                    string2 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                    if (n2 != -1) {
                        string2 = string2 + " - " + locale.getDisplayCountry(locale);
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
                }
            });
            this.languageComboBox.setMaximumRowCount(this.languageComboBox.getModel().getSize());
            this.languageComboBox.setSelectedItem(userPreferencesController.getLanguage());
            this.languageComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setLanguage((String)UserPreferencesPanel.this.languageComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.LANGUAGE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.languageComboBox.setSelectedItem(userPreferencesController.getLanguage());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.UNIT)) {
            this.unitLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitLabel.text", new Object[0]));
            this.centimeterRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "centimeterRadioButton.text", new Object[0]), userPreferencesController.getUnit() == LengthUnit.CENTIMETER);
            this.centimeterRadioButton.setActionCommand(LengthUnit.CENTIMETER.name());
            this.inchRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "inchRadioButton.text", new Object[0]), userPreferencesController.getUnit() == LengthUnit.INCH);
            this.inchRadioButton.setActionCommand(LengthUnit.INCH.name());
            this.millimeterRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "millimeterRadioButton.text", new Object[0]), userPreferencesController.getUnit() == LengthUnit.MILLIMETER);
            this.millimeterRadioButton.setActionCommand(LengthUnit.MILLIMETER.name());
            this.meterRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "meterRadioButton.text", new Object[0]), userPreferencesController.getUnit() == LengthUnit.METER);
            this.meterRadioButton.setActionCommand(LengthUnit.METER.name());
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.centimeterRadioButton);
            ((ButtonGroup)object).add(this.inchRadioButton);
            ((ButtonGroup)object).add(this.millimeterRadioButton);
            ((ButtonGroup)object).add(this.meterRadioButton);
            eventListener = new ItemListener((ButtonGroup)object){
                final /* synthetic */ ButtonGroup val$unitButtonGroup;
                {
                    this.val$unitButtonGroup = buttonGroup;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setUnit(LengthUnit.valueOf(this.val$unitButtonGroup.getSelection().getActionCommand()));
                }
            };
            this.centimeterRadioButton.addItemListener((ItemListener)eventListener);
            this.inchRadioButton.addItemListener((ItemListener)eventListener);
            this.millimeterRadioButton.addItemListener((ItemListener)eventListener);
            this.meterRadioButton.addItemListener((ItemListener)eventListener);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    switch (userPreferencesController.getUnit()) {
                        case CENTIMETER: {
                            UserPreferencesPanel.this.centimeterRadioButton.setSelected(true);
                            break;
                        }
                        case INCH: {
                            UserPreferencesPanel.this.inchRadioButton.setSelected(true);
                            break;
                        }
                        case MILLIMETER: {
                            UserPreferencesPanel.this.millimeterRadioButton.setSelected(true);
                            break;
                        }
                        case METER: {
                            UserPreferencesPanel.this.meterRadioButton.setSelected(true);
                        }
                    }
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_CATALOG_VIEWED_IN_TREE)) {
            this.furnitureCatalogViewLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "furnitureCatalogViewLabel.text", new Object[0]));
            this.treeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "treeRadioButton.text", new Object[0]), userPreferencesController.isFurnitureCatalogViewedInTree());
            this.listRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "listRadioButton.text", new Object[0]), !userPreferencesController.isFurnitureCatalogViewedInTree());
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.treeRadioButton);
            ((ButtonGroup)object).add(this.listRadioButton);
            eventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setFurnitureCatalogViewedInTree(UserPreferencesPanel.this.treeRadioButton.isSelected());
                }
            };
            this.treeRadioButton.addItemListener((ItemListener)eventListener);
            this.listRadioButton.addItemListener((ItemListener)eventListener);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.treeRadioButton.setSelected(userPreferencesController.isFurnitureCatalogViewedInTree());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NAVIGATION_PANEL_VISIBLE) && !"true".equalsIgnoreCase(System.getProperty("com.eteks.sweethome3d.no3D"))) {
            this.navigationPanelLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "navigationPanelLabel.text", new Object[0]));
            this.navigationPanelCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "navigationPanelCheckBox.text", new Object[0]));
            if (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior()) {
                this.navigationPanelCheckBox.setSelected(userPreferencesController.isNavigationPanelVisible());
                this.navigationPanelCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setNavigationPanelVisible(UserPreferencesPanel.this.navigationPanelCheckBox.isSelected());
                    }
                });
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NAVIGATION_PANEL_VISIBLE, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        UserPreferencesPanel.this.navigationPanelCheckBox.setSelected(userPreferencesController.isNavigationPanelVisible());
                    }
                });
            } else {
                this.navigationPanelCheckBox.setEnabled(false);
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.MAGNETISM_ENABLED)) {
            this.magnetismLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "magnetismLabel.text", new Object[0]));
            this.magnetismCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "magnetismCheckBox.text", new Object[0]), userPreferencesController.isMagnetismEnabled());
            this.magnetismCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setMagnetismEnabled(UserPreferencesPanel.this.magnetismCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.MAGNETISM_ENABLED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.magnetismCheckBox.setSelected(userPreferencesController.isMagnetismEnabled());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.RULERS_VISIBLE)) {
            this.rulersLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "rulersLabel.text", new Object[0]));
            this.rulersCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "rulersCheckBox.text", new Object[0]), userPreferencesController.isRulersVisible());
            this.rulersCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setRulersVisible(UserPreferencesPanel.this.rulersCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.RULERS_VISIBLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.rulersCheckBox.setSelected(userPreferencesController.isRulersVisible());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.GRID_VISIBLE)) {
            this.gridLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "gridLabel.text", new Object[0]));
            this.gridCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "gridCheckBox.text", new Object[0]), userPreferencesController.isGridVisible());
            this.gridCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setGridVisible(UserPreferencesPanel.this.gridCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.GRID_VISIBLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.gridCheckBox.setSelected(userPreferencesController.isGridVisible());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_VIEWED_FROM_TOP)) {
            this.furnitureIconLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "furnitureIconLabel.text", new Object[0]));
            this.catalogIconRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "catalogIconRadioButton.text", new Object[0]), !userPreferencesController.isFurnitureViewedFromTop());
            this.topViewRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "topViewRadioButton.text", new Object[0]), userPreferencesController.isFurnitureViewedFromTop());
            if ("true".equalsIgnoreCase(System.getProperty("com.eteks.sweethome3d.no3D"))) {
                this.catalogIconRadioButton.setEnabled(false);
                this.topViewRadioButton.setEnabled(false);
            } else if (Component3DManager.getInstance().isOffScreenImageSupported()) {
                object = new ButtonGroup();
                ((ButtonGroup)object).add(this.catalogIconRadioButton);
                ((ButtonGroup)object).add(this.topViewRadioButton);
                eventListener = new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setFurnitureViewedFromTop(UserPreferencesPanel.this.topViewRadioButton.isSelected());
                    }
                };
                this.catalogIconRadioButton.addItemListener((ItemListener)eventListener);
                this.topViewRadioButton.addItemListener((ItemListener)eventListener);
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_VIEWED_FROM_TOP, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        UserPreferencesPanel.this.topViewRadioButton.setSelected(userPreferencesController.isFurnitureViewedFromTop());
                    }
                });
            } else {
                this.catalogIconRadioButton.setEnabled(false);
                this.topViewRadioButton.setEnabled(false);
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.ROOM_FLOOR_COLORED_OR_TEXTURED)) {
            this.roomRenderingLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "roomRenderingLabel.text", new Object[0]));
            this.monochromeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "monochromeRadioButton.text", new Object[0]), !userPreferencesController.isRoomFloorColoredOrTextured());
            this.floorColorOrTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "floorColorOrTextureRadioButton.text", new Object[0]), userPreferencesController.isRoomFloorColoredOrTextured());
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.monochromeRadioButton);
            ((ButtonGroup)object).add(this.floorColorOrTextureRadioButton);
            eventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setRoomFloorColoredOrTextured(UserPreferencesPanel.this.floorColorOrTextureRadioButton.isSelected());
                }
            };
            this.monochromeRadioButton.addItemListener((ItemListener)eventListener);
            this.floorColorOrTextureRadioButton.addItemListener((ItemListener)eventListener);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.ROOM_FLOOR_COLORED_OR_TEXTURED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.floorColorOrTextureRadioButton.setSelected(userPreferencesController.isRoomFloorColoredOrTextured());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.WALL_PATTERN)) {
            this.wallPatternLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "wallPatternLabel.text", new Object[0]));
            object = userPreferences.getPatternsCatalog().getPatterns();
            this.wallPatternComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(object.toArray()));
            this.wallPatternComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                    TextureImage textureImage = (TextureImage)object;
                    Component component = super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                    final BufferedImage bufferedImage = SwingTools.getPatternImage(textureImage, jList.getBackground(), jList.getForeground());
                    this.setIcon(new Icon(){

                        public int getIconWidth() {
                            return bufferedImage.getWidth() * 4 + 1;
                        }

                        public int getIconHeight() {
                            return bufferedImage.getHeight() + 2;
                        }

                        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            for (int i = 0; i < 4; ++i) {
                                graphics2D.drawImage((Image)bufferedImage, n + i * bufferedImage.getWidth(), n2 + 1, jList);
                            }
                            graphics2D.setColor(jList.getForeground());
                            graphics2D.drawRect(n, n2, this.getIconWidth() - 2, this.getIconHeight() - 1);
                        }
                    });
                    return component;
                }
            });
            this.wallPatternComboBox.setSelectedItem(userPreferencesController.getWallPattern());
            this.wallPatternComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setWallPattern((TextureImage)UserPreferencesPanel.this.wallPatternComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.WALL_PATTERN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.wallPatternComboBox.setSelectedItem(userPreferencesController.getWallPattern());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_THICKNESS)) {
            this.newWallThicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallThicknessLabel.text", new Object[0]));
            object = new SpinnerLengthModel(0.5f, 0.125f, 5.0f, 0.005f, userPreferencesController);
            this.newWallThicknessSpinner = new AutoCommitSpinner((SpinnerModel)object);
            ((SpinnerLengthModel)object).setLength(userPreferencesController.getNewWallThickness());
            ((AbstractSpinnerModel)object).addChangeListener(new ChangeListener((SpinnerLengthModel)object){
                final /* synthetic */ SpinnerLengthModel val$newWallThicknessSpinnerModel;
                {
                    this.val$newWallThicknessSpinnerModel = spinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewWallThickness(this.val$newWallThicknessSpinnerModel.getLength());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_THICKNESS, new PropertyChangeListener((SpinnerLengthModel)object, userPreferencesController){
                final /* synthetic */ SpinnerLengthModel val$newWallThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                {
                    this.val$newWallThicknessSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newWallThicknessSpinnerModel.setLength(this.val$controller.getNewWallThickness());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_HEIGHT)) {
            this.newWallHeightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallHeightLabel.text", new Object[0]));
            object = new SpinnerLengthModel(10.0f, 2.0f, 100.0f, 0.1f, userPreferencesController);
            this.newWallHeightSpinner = new AutoCommitSpinner((SpinnerModel)object);
            ((SpinnerLengthModel)object).setLength(userPreferencesController.getNewWallHeight());
            ((AbstractSpinnerModel)object).addChangeListener(new ChangeListener((SpinnerLengthModel)object){
                final /* synthetic */ SpinnerLengthModel val$newWallHeightSpinnerModel;
                {
                    this.val$newWallHeightSpinnerModel = spinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewWallHeight(this.val$newWallHeightSpinnerModel.getLength());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_HEIGHT, new PropertyChangeListener((SpinnerLengthModel)object, userPreferencesController){
                final /* synthetic */ SpinnerLengthModel val$newWallHeightSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                {
                    this.val$newWallHeightSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newWallHeightSpinnerModel.setLength(this.val$controller.getNewWallHeight());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.AUTO_SAVE_DELAY_FOR_RECOVERY)) {
            this.autoSaveDelayForRecoveryCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "autoSaveDelayForRecoveryCheckBox.text", new Object[0]));
            object = new SpinnerNumberModel(10, 1, 60, 5){

                public Object getNextValue() {
                    if (((Number)this.getValue()).intValue() == ((Number)((Object)this.getMinimum())).intValue()) {
                        return this.getStepSize();
                    }
                    return super.getNextValue();
                }

                public Object getPreviousValue() {
                    if (((Number)this.getValue()).intValue() - this.getStepSize().intValue() < ((Number)((Object)this.getMinimum())).intValue()) {
                        return super.getMinimum();
                    }
                    return super.getPreviousValue();
                }
            };
            this.autoSaveDelayForRecoverySpinner = new AutoCommitSpinner((SpinnerModel)object);
            this.autoSaveDelayForRecoveryUnitLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "autoSaveDelayForRecoveryUnitLabel.text", new Object[0]));
            this.updateAutoSaveDelayForRecoveryComponents(userPreferencesController);
            this.autoSaveDelayForRecoveryCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setAutoSaveForRecoveryEnabled(UserPreferencesPanel.this.autoSaveDelayForRecoveryCheckBox.isSelected());
                }
            });
            ((AbstractSpinnerModel)object).addChangeListener(new ChangeListener((SpinnerNumberModel)object){
                final /* synthetic */ SpinnerNumberModel val$autoSaveDelayForRecoverySpinnerModel;
                {
                    this.val$autoSaveDelayForRecoverySpinnerModel = spinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setAutoSaveDelayForRecovery(((Number)this.val$autoSaveDelayForRecoverySpinnerModel.getValue()).intValue() * 60000);
                }
            });
            eventListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    UserPreferencesPanel.this.updateAutoSaveDelayForRecoveryComponents(userPreferencesController);
                }
            };
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AUTO_SAVE_DELAY_FOR_RECOVERY, (PropertyChangeListener)eventListener);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AUTO_SAVE_FOR_RECOVERY_ENABLED, (PropertyChangeListener)eventListener);
        }
        this.resetDisplayedActionTipsButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(userPreferences, UserPreferencesPanel.class, "RESET_DISPLAYED_ACTION_TIPS", true){

            public void actionPerformed(ActionEvent actionEvent) {
                userPreferencesController.resetDisplayedActionTips();
            }
        }));
        this.dialogTitle = userPreferences.getLocalizedString(UserPreferencesPanel.class, "preferences.title", new Object[0]);
    }

    private void updateAutoSaveDelayForRecoveryComponents(UserPreferencesController userPreferencesController) {
        int n = userPreferencesController.getAutoSaveDelayForRecovery() / 60000;
        boolean bl = userPreferencesController.isAutoSaveForRecoveryEnabled();
        this.autoSaveDelayForRecoverySpinner.setEnabled(bl);
        this.autoSaveDelayForRecoveryCheckBox.setSelected(bl);
        if (bl) {
            this.autoSaveDelayForRecoverySpinner.setValue(n);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.languageLabel != null) {
                this.languageLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "languageLabel.mnemonic", new Object[0])).getKeyCode());
                this.languageLabel.setLabelFor(this.languageComboBox);
            }
            if (this.unitLabel != null) {
                this.centimeterRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "centimeterRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.inchRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "inchRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.millimeterRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "millimeterRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.meterRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "meterRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.furnitureCatalogViewLabel != null) {
                this.treeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "treeRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.listRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "listRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.navigationPanelLabel != null) {
                this.navigationPanelCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "navigationPanelCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.magnetismLabel != null) {
                this.magnetismCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "magnetismCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.rulersLabel != null) {
                this.rulersCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "rulersCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.gridLabel != null) {
                this.gridCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "gridCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.furnitureIconLabel != null) {
                this.catalogIconRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "catalogIconRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.topViewRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "topViewRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.roomRenderingLabel != null) {
                this.monochromeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "monochromeRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.floorColorOrTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "floorColorOrTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.wallPatternLabel != null) {
                this.wallPatternLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "wallPatternLabel.mnemonic", new Object[0])).getKeyCode());
                this.wallPatternLabel.setLabelFor(this.wallPatternComboBox);
            }
            if (this.newWallThicknessLabel != null) {
                this.newWallThicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallThicknessLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallThicknessLabel.setLabelFor(this.newWallThicknessSpinner);
            }
            if (this.newWallHeightLabel != null) {
                this.newWallHeightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallHeightLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallHeightLabel.setLabelFor(this.newWallHeightSpinner);
            }
            if (this.autoSaveDelayForRecoveryCheckBox != null) {
                this.autoSaveDelayForRecoveryCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "autoSaveDelayForRecoveryCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        Insets insets = new Insets(0, 0, 5, 5);
        Insets insets2 = new Insets(0, 0, 10, 5);
        Insets insets3 = new Insets(0, 0, 5, 0);
        Insets insets4 = new Insets(0, 0, 10, 0);
        if (this.languageLabel != null) {
            this.add((Component)this.languageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.languageComboBox, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.unitLabel != null) {
            this.add((Component)this.unitLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.centimeterRadioButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 2, 5), 0, 0));
            this.add((Component)this.inchRadioButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 2, 0), 0, 0));
            this.add((Component)this.millimeterRadioButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
            this.add((Component)this.meterRadioButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 21, 0, insets4, 0, 0));
        }
        if (this.furnitureCatalogViewLabel != null) {
            this.add((Component)this.furnitureCatalogViewLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.treeRadioButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.add((Component)this.listRadioButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.navigationPanelLabel != null) {
            this.add((Component)this.navigationPanelLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.navigationPanelCheckBox, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 21, 0, insets4, 0, 0));
        }
        if (this.magnetismLabel != null) {
            this.add((Component)this.magnetismLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.magnetismCheckBox, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.rulersLabel != null) {
            this.add((Component)this.rulersLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.rulersCheckBox, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.gridLabel != null) {
            this.add((Component)this.gridLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.gridCheckBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.furnitureIconLabel != null) {
            this.add((Component)this.furnitureIconLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.catalogIconRadioButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.add((Component)this.topViewRadioButton, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.roomRenderingLabel != null) {
            this.add((Component)this.roomRenderingLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.monochromeRadioButton, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.add((Component)this.floorColorOrTextureRadioButton, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.wallPatternLabel != null) {
            this.add((Component)this.wallPatternLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.wallPatternComboBox, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 21, 0, insets3, 0, 0));
        }
        if (this.newWallThicknessLabel != null) {
            this.add((Component)this.newWallThicknessLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallThicknessSpinner, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.newWallHeightLabel != null) {
            this.add((Component)this.newWallHeightLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallHeightSpinner, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.autoSaveDelayForRecoveryCheckBox != null) {
            JPanel jPanel = new JPanel();
            jPanel.add(this.autoSaveDelayForRecoveryCheckBox);
            jPanel.add(this.autoSaveDelayForRecoverySpinner);
            jPanel.add(this.autoSaveDelayForRecoveryUnitLabel);
            this.add((Component)jPanel, new GridBagConstraints(0, 13, 3, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        }
        if (this.resetDisplayedActionTipsButton.getText() != null && this.resetDisplayedActionTipsButton.getText().length() > 0) {
            this.add((Component)this.resetDisplayedActionTipsButton, new GridBagConstraints(0, 14, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.languageComboBox) == 0 && this.controller != null) {
            this.controller.modifyUserPreferences();
        }
    }

    private static class SpinnerLengthModel
    extends SpinnerNumberModel {
        private LengthUnit unit = LengthUnit.CENTIMETER;

        public SpinnerLengthModel(final float f, final float f2, final float f3, final float f4, final UserPreferencesController userPreferencesController) {
            super(new Float(1.0f), new Float(0.0f), new Float(100000.0f), new Float(f));
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SpinnerLengthModel.this.updateStepsAndLength(f, f2, f3, f4, userPreferencesController);
                }
            });
            this.updateStepsAndLength(f, f2, f3, f4, userPreferencesController);
        }

        private void updateStepsAndLength(float f, float f2, float f3, float f4, UserPreferencesController userPreferencesController) {
            float f5 = this.getLength();
            this.unit = userPreferencesController.getUnit();
            switch (userPreferencesController.getUnit()) {
                case CENTIMETER: {
                    this.setStepSize(Float.valueOf(f));
                    break;
                }
                case INCH: {
                    this.setStepSize(Float.valueOf(f2));
                    break;
                }
                case MILLIMETER: {
                    this.setStepSize(Float.valueOf(f3));
                    break;
                }
                case METER: {
                    this.setStepSize(Float.valueOf(f4));
                }
            }
            this.setLength(f5);
        }

        public float getLength() {
            return this.unit.unitToCentimeter(this.getNumber().floatValue());
        }

        public void setLength(float f) {
            this.setValue(Float.valueOf(this.unit.centimeterToUnit(f)));
        }
    }
}

