/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ExtensionsClassLoader
extends ClassLoader {
    private final ProtectionDomain protectionDomain;
    private final String[] applicationPackages;
    private final Map extensionDlls = new HashMap();
    private JarFile[] extensionJars = null;

    public ExtensionsClassLoader(ClassLoader classLoader, ProtectionDomain protectionDomain, String[] stringArray, String[] stringArray2) {
        this(classLoader, protectionDomain, stringArray, new URL[0], stringArray2, null, null);
    }

    public ExtensionsClassLoader(ClassLoader classLoader, ProtectionDomain protectionDomain, String[] stringArray, URL[] uRLArray, String[] stringArray2, File file, String string) {
        super(classLoader);
        String string2;
        String string3;
        this.protectionDomain = protectionDomain;
        this.applicationPackages = stringArray2;
        String string4 = string == null ? "" : string;
        String string5 = System.getProperty("os.name");
        if (string5.startsWith("Windows")) {
            string3 = ".dll";
            string2 = "";
        } else if (string5.startsWith("Mac OS X")) {
            string3 = ".jnilib";
            string2 = "lib";
        } else {
            string3 = ".so";
            string2 = "lib";
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL = this.getResource(stringArray[i]);
            if (uRL == null) continue;
            arrayList.add(uRL);
        }
        arrayList.addAll(Arrays.asList(uRLArray));
        ArrayList<JarFile> arrayList2 = new ArrayList<JarFile>();
        for (int i = 0; i < arrayList.size(); ++i) {
            URL uRL = (URL)arrayList.get(i);
            try {
                String string6;
                Object object;
                String string7;
                long l;
                Object object2;
                String string8 = uRL.getFile();
                URLConnection uRLConnection = null;
                if (uRL.getProtocol().equals("jar")) {
                    object2 = new URL(string8.substring(0, string8.indexOf(33)));
                    URLConnection uRLConnection2 = ((URL)object2).openConnection();
                    l = uRLConnection2.getLastModified();
                    string7 = string8.substring(string8.indexOf(33) + 2);
                } else {
                    uRLConnection = uRL.openConnection();
                    l = uRLConnection.getLastModified();
                    string7 = string8;
                }
                int n = string7.lastIndexOf(47);
                object2 = string7.endsWith(".jar") ? string4 + string7.substring(n + 1) : string4 + string7.substring(n + 1 + string2.length());
                if (file != null && (file.exists() && file.isDirectory() || file.mkdirs())) {
                    try {
                        object = new File(file, (String)object2);
                        if (!((File)object).exists() || ((File)object).lastModified() < l) {
                            if (uRLConnection == null) {
                                uRLConnection = uRL.openConnection();
                            }
                            this.copyInputStreamToFile(uRLConnection.getInputStream(), (File)object);
                        }
                        if (string7.endsWith(".jar")) {
                            arrayList2.add(new JarFile(((File)object).toString(), false));
                            continue;
                        }
                        if (!string7.endsWith(string3)) continue;
                        this.extensionDlls.put(((String)object2).substring(string4.length(), ((String)object2).indexOf(string3)), ((File)object).toString());
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (uRLConnection == null) {
                    uRLConnection = uRL.openConnection();
                }
                object = uRLConnection.getInputStream();
                if (string7.endsWith(".jar")) {
                    string6 = this.copyInputStreamToTmpFile((InputStream)object, ".jar");
                    arrayList2.add(new JarFile(string6, false));
                    continue;
                }
                if (!string7.endsWith(string3)) continue;
                string6 = this.copyInputStreamToTmpFile((InputStream)object, string3);
                this.extensionDlls.put(((String)object2).substring(string4.length(), ((String)object2).indexOf(string3)), string6);
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Couldn't extract extension jars", iOException);
            }
        }
        if (arrayList2.size() > 0) {
            this.extensionJars = arrayList2.toArray(new JarFile[arrayList2.size()]);
        }
    }

    private String copyInputStreamToTmpFile(InputStream inputStream, String string) throws IOException {
        File file = File.createTempFile("extension", string);
        file.deleteOnExit();
        this.copyInputStreamToFile(inputStream, file);
        return file.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInputStreamToFile(InputStream inputStream, File file) throws FileNotFoundException, IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Object object;
        Closeable closeable;
        String string2 = string.replace('.', '/') + ".class";
        InputStream inputStream = null;
        if (this.extensionJars != null) {
            for (int i = 0; i < this.extensionJars.length; ++i) {
                closeable = this.extensionJars[i];
                object = ((JarFile)closeable).getJarEntry(string2);
                if (object == null) continue;
                try {
                    inputStream = ((JarFile)closeable).getInputStream((ZipEntry)object);
                    continue;
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException("Couldn't read class " + string, iOException);
                }
            }
        }
        if (inputStream == null) {
            URL uRL = this.getResource(string2);
            if (uRL == null) {
                throw new ClassNotFoundException("Class " + string);
            }
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Couldn't read class " + string, iOException);
            }
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            closeable = new BufferedInputStream(inputStream);
            object = new byte[8192];
            while ((n = ((FilterInputStream)closeable).read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            ((BufferedInputStream)closeable).close();
            return this.defineClass(string, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), this.protectionDomain);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Class " + string, iOException);
        }
    }

    protected String findLibrary(String string) {
        return (String)this.extensionDlls.get(string);
    }

    protected URL findResource(String string) {
        if (this.extensionJars != null) {
            for (int i = 0; i < this.extensionJars.length; ++i) {
                JarFile jarFile = this.extensionJars[i];
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry == null) continue;
                try {
                    return new URL("jar:file:" + jarFile.getName() + ":" + jarEntry.getName());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return super.findResource(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.extensionJars == null) {
            return super.loadClass(string, bl);
        }
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                for (int i = 0; i < this.applicationPackages.length; ++i) {
                    String string2 = this.applicationPackages[i];
                    int n = string2.length();
                    if ((n != 0 || string.indexOf(46) != 0) && (n <= 0 || !string.startsWith(string2))) continue;
                    clazz = this.findClass(string);
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = super.loadClass(string, bl);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

