/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.tools;

import com.apple.eio.FileManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class OperatingSystem {
    private static final String EDITOR_SUB_FOLDER;
    private static final String APPLICATION_SUB_FOLDER;
    private static final String TEMPORARY_SUB_FOLDER;
    private static final String TEMPORARY_SESSION_SUB_FOLDER;

    private OperatingSystem() {
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    public static boolean isMacOSXLeopardOrSuperior() {
        return OperatingSystem.isMacOSX() && !System.getProperty("os.version").startsWith("10.4");
    }

    public static File createTemporaryFile(String string, String string2) throws IOException {
        File file;
        try {
            file = OperatingSystem.getDefaultTemporaryFolder(true);
        }
        catch (IOException iOException) {
            file = null;
        }
        File file2 = File.createTempFile(string, string2, file);
        file2.deleteOnExit();
        return file2;
    }

    public static void deleteTemporaryFiles() {
        try {
            File file = OperatingSystem.getDefaultTemporaryFolder(false);
            if (file != null) {
                for (File file2 : file.listFiles()) {
                    file2.delete();
                }
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized File getDefaultTemporaryFolder(boolean bl) throws IOException {
        if (TEMPORARY_SUB_FOLDER != null) {
            File file = new File(OperatingSystem.getDefaultApplicationFolder(), TEMPORARY_SUB_FOLDER);
            final File file2 = new File(file, "3300-" + TEMPORARY_SESSION_SUB_FOLDER);
            if (!file2.exists()) {
                final File[] fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().startsWith("3300-");
                    }
                });
                if (!file2.mkdirs()) {
                    throw new IOException("Can't create temporary folder " + file2);
                }
                file2.deleteOnExit();
                new Timer(true).schedule(new TimerTask(){

                    public void run() {
                        file2.setLastModified(Math.max(System.currentTimeMillis(), file2.lastModified() + 60000L));
                    }
                }, 60000L, 60000L);
                if (fileArray != null && fileArray.length > 0) {
                    new Timer(true).schedule(new TimerTask(){

                        public void run() {
                            long l = System.currentTimeMillis();
                            for (File file : fileArray) {
                                File[] fileArray2;
                                if (!file.exists() || l - file.lastModified() <= 604800000L) continue;
                                for (File file2 : fileArray2 = file.listFiles()) {
                                    file2.delete();
                                }
                                file.delete();
                            }
                        }
                    }, 600000L);
                }
            }
            return file2;
        }
        return null;
    }

    public static File getDefaultApplicationFolder() throws IOException {
        File file;
        if (OperatingSystem.isMacOSX()) {
            file = new File(MacOSXFileManager.getApplicationSupportFolder());
        } else if (OperatingSystem.isWindows()) {
            file = new File(System.getProperty("user.home"), "Application Data");
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"));
            }
        } else {
            file = new File(System.getProperty("user.home"));
        }
        return new File(file, EDITOR_SUB_FOLDER + File.separator + APPLICATION_SUB_FOLDER);
    }

    static {
        String string;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(OperatingSystem.class.getName());
        if (OperatingSystem.isMacOSX()) {
            EDITOR_SUB_FOLDER = resourceBundle.getString("editorSubFolder.Mac OS X");
            APPLICATION_SUB_FOLDER = resourceBundle.getString("applicationSubFolder.Mac OS X");
        } else if (OperatingSystem.isWindows()) {
            EDITOR_SUB_FOLDER = resourceBundle.getString("editorSubFolder.Windows");
            APPLICATION_SUB_FOLDER = resourceBundle.getString("applicationSubFolder.Windows");
        } else {
            EDITOR_SUB_FOLDER = resourceBundle.getString("editorSubFolder");
            APPLICATION_SUB_FOLDER = resourceBundle.getString("applicationSubFolder");
        }
        try {
            string = resourceBundle.getString("temporarySubFolder");
            if (string.trim().length() == 0) {
                string = null;
            }
        }
        catch (MissingResourceException missingResourceException) {
            string = "work";
        }
        TEMPORARY_SUB_FOLDER = string = System.getProperty("com.eteks.sweethome3d.tools.temporarySubFolder", string);
        TEMPORARY_SESSION_SUB_FOLDER = UUID.randomUUID().toString();
    }

    private static class MacOSXFileManager {
        private MacOSXFileManager() {
        }

        public static String getApplicationSupportFolder() throws IOException {
            return FileManager.findFolder((short)-32763, (int)1634956656);
        }
    }
}

