/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.tools;

import com.eteks.sweethome3d.model.Content;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class URLContent
implements Content {
    private static final long serialVersionUID = 1L;
    private URL url;

    public URLContent(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public InputStream openStream() throws IOException {
        return this.url.openStream();
    }

    public boolean isJAREntry() {
        return "jar".equals(this.url.getProtocol());
    }

    public URL getJAREntryURL() {
        if (!this.isJAREntry()) {
            throw new IllegalStateException("Content isn't a JAR entry");
        }
        try {
            String string = this.url.getFile();
            return new URL(string.substring(0, string.indexOf(33)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Invalid URL base for JAR entry", malformedURLException);
        }
    }

    public String getJAREntryName() {
        if (!this.isJAREntry()) {
            throw new IllegalStateException("Content isn't a JAR entry");
        }
        String string = this.url.getFile();
        return string.substring(string.indexOf(33) + 2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof URLContent) {
            URLContent uRLContent = (URLContent)object;
            return uRLContent.url == this.url || uRLContent.url.equals(this.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

