/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class Home3DAttributesController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private TextureChoiceController groundTextureController;
    private TextureChoiceController skyTextureController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView home3DAttributesView;
    private int observerFieldOfViewInDegrees;
    private float observerHeight;
    private int groundColor;
    private EnvironmentPaint groundPaint;
    private int skyColor;
    private EnvironmentPaint skyPaint;
    private int lightColor;
    private float wallsAlpha;

    public Home3DAttributesController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getGroundTextureController() {
        if (this.groundTextureController == null) {
            this.groundTextureController = new TextureChoiceController(this.preferences.getLocalizedString(Home3DAttributesController.class, "groundTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.groundTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Home3DAttributesController.this.setGroundPaint(EnvironmentPaint.TEXTURED);
                }
            });
        }
        return this.groundTextureController;
    }

    public TextureChoiceController getSkyTextureController() {
        if (this.skyTextureController == null) {
            this.skyTextureController = new TextureChoiceController(this.preferences.getLocalizedString(Home3DAttributesController.class, "skyTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.skyTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Home3DAttributesController.this.setSkyPaint(EnvironmentPaint.TEXTURED);
                }
            });
        }
        return this.skyTextureController;
    }

    public DialogView getView() {
        if (this.home3DAttributesView == null) {
            this.home3DAttributesView = this.viewFactory.createHome3DAttributesView(this.preferences, this);
        }
        return this.home3DAttributesView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        this.setObserverFieldOfViewInDegrees((int)(Math.round(Math.toDegrees(this.home.getObserverCamera().getFieldOfView())) + 360L) % 360);
        this.setObserverHeight(this.home.getObserverCamera().getZ() * 15.0f / 14.0f);
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        this.setGroundColor(homeEnvironment.getGroundColor());
        HomeTexture homeTexture = homeEnvironment.getGroundTexture();
        this.getGroundTextureController().setTexture(homeTexture);
        if (homeTexture != null) {
            this.setGroundPaint(EnvironmentPaint.TEXTURED);
        } else {
            this.setGroundPaint(EnvironmentPaint.COLORED);
        }
        this.setSkyColor(homeEnvironment.getSkyColor());
        HomeTexture homeTexture2 = homeEnvironment.getSkyTexture();
        this.getSkyTextureController().setTexture(homeTexture2);
        if (homeTexture2 != null) {
            this.setSkyPaint(EnvironmentPaint.TEXTURED);
        } else {
            this.setSkyPaint(EnvironmentPaint.COLORED);
        }
        this.setLightColor(homeEnvironment.getLightColor());
        this.setWallsAlpha(homeEnvironment.getWallsAlpha());
    }

    public void setObserverFieldOfViewInDegrees(int n) {
        if (n != this.observerFieldOfViewInDegrees) {
            int n2 = this.observerFieldOfViewInDegrees;
            this.observerFieldOfViewInDegrees = n;
            this.propertyChangeSupport.firePropertyChange(Property.OBSERVER_FIELD_OF_VIEW_IN_DEGREES.name(), n2, n);
        }
    }

    public int getObserverFieldOfViewInDegrees() {
        return this.observerFieldOfViewInDegrees;
    }

    public void setObserverHeight(float f) {
        if (f != this.observerHeight) {
            float f2 = this.observerHeight;
            this.observerHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.OBSERVER_HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getObserverHeight() {
        return this.observerHeight;
    }

    public void setGroundColor(int n) {
        if (n != this.groundColor) {
            int n2 = this.groundColor;
            this.groundColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.GROUND_COLOR.name(), n2, n);
            this.setGroundPaint(EnvironmentPaint.COLORED);
        }
    }

    public int getGroundColor() {
        return this.groundColor;
    }

    public void setGroundPaint(EnvironmentPaint environmentPaint) {
        if (environmentPaint != this.groundPaint) {
            EnvironmentPaint environmentPaint2 = this.groundPaint;
            this.groundPaint = environmentPaint;
            this.propertyChangeSupport.firePropertyChange(Property.GROUND_PAINT.name(), (Object)environmentPaint2, (Object)environmentPaint);
        }
    }

    public EnvironmentPaint getGroundPaint() {
        return this.groundPaint;
    }

    public void setSkyColor(int n) {
        if (n != this.skyColor) {
            int n2 = this.skyColor;
            this.skyColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.SKY_COLOR.name(), n2, n);
        }
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public void setSkyPaint(EnvironmentPaint environmentPaint) {
        if (environmentPaint != this.skyPaint) {
            EnvironmentPaint environmentPaint2 = this.skyPaint;
            this.skyPaint = environmentPaint;
            this.propertyChangeSupport.firePropertyChange(Property.SKY_PAINT.name(), (Object)environmentPaint2, (Object)environmentPaint);
        }
    }

    public EnvironmentPaint getSkyPaint() {
        return this.skyPaint;
    }

    public void setLightColor(int n) {
        if (n != this.lightColor) {
            int n2 = this.lightColor;
            this.lightColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.LIGHT_COLOR.name(), n2, n);
        }
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public void setWallsAlpha(float f) {
        if (f != this.wallsAlpha) {
            float f2 = this.wallsAlpha;
            this.wallsAlpha = f;
            this.propertyChangeSupport.firePropertyChange(Property.WALLS_ALPHA.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallsAlpha() {
        return this.wallsAlpha;
    }

    public void modify3DAttributes() {
        float f = (float)Math.toRadians(this.getObserverFieldOfViewInDegrees());
        float f2 = this.getObserverHeight() * 14.0f / 15.0f;
        int n = this.getGroundColor();
        HomeTexture homeTexture = this.getGroundPaint() == EnvironmentPaint.TEXTURED ? this.getGroundTextureController().getTexture() : null;
        int n2 = this.getSkyColor();
        HomeTexture homeTexture2 = this.getSkyPaint() == EnvironmentPaint.TEXTURED ? this.getSkyTextureController().getTexture() : null;
        int n3 = this.getLightColor();
        float f3 = this.getWallsAlpha();
        float f4 = this.home.getObserverCamera().getFieldOfView();
        float f5 = this.home.getObserverCamera().getZ();
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        int n4 = homeEnvironment.getGroundColor();
        HomeTexture homeTexture3 = homeEnvironment.getGroundTexture();
        int n5 = homeEnvironment.getSkyColor();
        HomeTexture homeTexture4 = homeEnvironment.getSkyTexture();
        int n6 = homeEnvironment.getLightColor();
        float f6 = homeEnvironment.getWallsAlpha();
        Home3DAttributesController.doModify3DAttributes(this.home, f, f2, n, homeTexture, n2, homeTexture2, n3, f3);
        if (this.undoSupport != null) {
            Home3DAttributesModificationUndoableEdit home3DAttributesModificationUndoableEdit = new Home3DAttributesModificationUndoableEdit(this.home, this.preferences, f4, f5, n4, homeTexture3, n5, homeTexture4, n6, f6, f, f2, n, homeTexture, n2, homeTexture2, n3, f3);
            this.undoSupport.postEdit(home3DAttributesModificationUndoableEdit);
        }
    }

    private static void doModify3DAttributes(Home home, float f, float f2, int n, HomeTexture homeTexture, int n2, HomeTexture homeTexture2, int n3, float f3) {
        ObserverCamera observerCamera = home.getObserverCamera();
        observerCamera.setFieldOfView(f);
        observerCamera.setZ(f2);
        HomeEnvironment homeEnvironment = home.getEnvironment();
        homeEnvironment.setGroundColor(n);
        homeEnvironment.setGroundTexture(homeTexture);
        homeEnvironment.setSkyColor(n2);
        homeEnvironment.setSkyTexture(homeTexture2);
        homeEnvironment.setLightColor(n3);
        homeEnvironment.setWallsAlpha(f3);
    }

    private static class Home3DAttributesModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final float oldObserverCameraFieldOfView;
        private final float oldObserverCameraZ;
        private final int oldGroundColor;
        private final HomeTexture oldGroundTexture;
        private final int oldSkyColor;
        private final HomeTexture oldSkyTexture;
        private final int oldLightColor;
        private final float oldWallsAlpha;
        private final float observerCameraFieldOfView;
        private final float observerCameraZ;
        private final int groundColor;
        private final HomeTexture groundTexture;
        private final int skyColor;
        private final HomeTexture skyTexture;
        private final int lightColor;
        private final float wallsAlpha;

        private Home3DAttributesModificationUndoableEdit(Home home, UserPreferences userPreferences, float f, float f2, int n, HomeTexture homeTexture, int n2, HomeTexture homeTexture2, int n3, float f3, float f4, float f5, int n4, HomeTexture homeTexture3, int n5, HomeTexture homeTexture4, int n6, float f6) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldObserverCameraFieldOfView = f;
            this.oldObserverCameraZ = f2;
            this.oldGroundColor = n;
            this.oldGroundTexture = homeTexture;
            this.oldSkyColor = n2;
            this.oldSkyTexture = homeTexture2;
            this.oldLightColor = n3;
            this.oldWallsAlpha = f3;
            this.observerCameraFieldOfView = f4;
            this.observerCameraZ = f5;
            this.groundColor = n4;
            this.groundTexture = homeTexture3;
            this.skyColor = n5;
            this.skyTexture = homeTexture4;
            this.lightColor = n6;
            this.wallsAlpha = f6;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Home3DAttributesController.doModify3DAttributes(this.home, this.oldObserverCameraFieldOfView, this.oldObserverCameraZ, this.oldGroundColor, this.oldGroundTexture, this.oldSkyColor, this.oldSkyTexture, this.oldLightColor, this.oldWallsAlpha);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Home3DAttributesController.doModify3DAttributes(this.home, this.observerCameraFieldOfView, this.observerCameraZ, this.groundColor, this.groundTexture, this.skyColor, this.skyTexture, this.lightColor, this.wallsAlpha);
        }

        public String getPresentationName() {
            return this.preferences.getLocalizedString(Home3DAttributesController.class, "undoModify3DAttributesName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnvironmentPaint {
        COLORED,
        TEXTURED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        OBSERVER_FIELD_OF_VIEW_IN_DEGREES,
        OBSERVER_HEIGHT,
        GROUND_COLOR,
        GROUND_PAINT,
        SKY_COLOR,
        SKY_PAINT,
        LIGHT_COLOR,
        WALLS_ALPHA;

    }
}

