/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.plugin.Plugin;
import com.eteks.sweethome3d.plugin.PluginManager;
import com.eteks.sweethome3d.viewcontroller.BackgroundImageWizardController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.HelpController;
import com.eteks.sweethome3d.viewcontroller.HomeController3D;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.PageSetupController;
import com.eteks.sweethome3d.viewcontroller.PhotoController;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PrintPreviewController;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import com.eteks.sweethome3d.viewcontroller.UserPreferencesController;
import com.eteks.sweethome3d.viewcontroller.VideoController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final HomeApplication application;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PluginManager pluginManager;
    private final UndoableEditSupport undoSupport;
    private final UndoManager undoManager;
    private HomeView homeView;
    private FurnitureCatalogController furnitureCatalogController;
    private FurnitureController furnitureController;
    private PlanController planController;
    private HomeController3D homeController3D;
    private static HelpController helpController;
    private int saveUndoLevel;
    private boolean notUndoableModifications;
    private View focusedView;

    public HomeController(Home home, HomeApplication homeApplication, ViewFactory viewFactory, ContentManager contentManager, PluginManager pluginManager) {
        this(home, homeApplication.getUserPreferences(), viewFactory, contentManager, homeApplication, pluginManager);
    }

    public HomeController(Home home, HomeApplication homeApplication, ViewFactory viewFactory) {
        this(home, homeApplication.getUserPreferences(), viewFactory, null, homeApplication, null);
    }

    public HomeController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this(home, userPreferences, viewFactory, null, null, null);
    }

    public HomeController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(home, userPreferences, viewFactory, contentManager, null, null);
    }

    private HomeController(final Home home, final UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, HomeApplication homeApplication, PluginManager pluginManager) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.application = homeApplication;
        this.pluginManager = pluginManager;
        this.undoSupport = new UndoableEditSupport(){

            protected void _postEdit(UndoableEdit undoableEdit) {
                if (!(undoableEdit instanceof CompoundEdit) || undoableEdit.isSignificant()) {
                    super._postEdit(undoableEdit);
                }
            }
        };
        this.undoManager = new UndoManager();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        if (home.getName() != null) {
            ArrayList<String> arrayList = new ArrayList<String>(this.preferences.getRecentHomes());
            arrayList.remove(home.getName());
            arrayList.add(0, home.getName());
            this.updateUserPreferencesRecentHomes(arrayList);
            if (home.getVersion() > 3300L) {
                this.getView().invokeLater(new Runnable(){

                    public void run() {
                        String string = userPreferences.getLocalizedString(HomeController.class, "moreRecentVersionHome", home.getName());
                        HomeController.this.getView().showMessage(string);
                    }
                });
            }
        }
    }

    private void enableDefaultActions(HomeView homeView) {
        boolean bl = this.application != null;
        homeView.setEnabled(HomeView.ActionType.NEW_HOME, bl);
        homeView.setEnabled(HomeView.ActionType.OPEN, bl);
        homeView.setEnabled(HomeView.ActionType.DELETE_RECENT_HOMES, bl && !this.preferences.getRecentHomes().isEmpty());
        homeView.setEnabled(HomeView.ActionType.CLOSE, bl);
        homeView.setEnabled(HomeView.ActionType.SAVE, bl);
        homeView.setEnabled(HomeView.ActionType.SAVE_AS, bl);
        homeView.setEnabled(HomeView.ActionType.SAVE_AND_COMPRESS, bl);
        homeView.setEnabled(HomeView.ActionType.PAGE_SETUP, true);
        homeView.setEnabled(HomeView.ActionType.PRINT_PREVIEW, true);
        homeView.setEnabled(HomeView.ActionType.PRINT, true);
        homeView.setEnabled(HomeView.ActionType.PRINT_TO_PDF, true);
        homeView.setEnabled(HomeView.ActionType.PREFERENCES, true);
        homeView.setEnabled(HomeView.ActionType.EXIT, bl);
        homeView.setEnabled(HomeView.ActionType.IMPORT_FURNITURE, true);
        homeView.setEnabled(HomeView.ActionType.IMPORT_FURNITURE_LIBRARY, true);
        homeView.setEnabled(HomeView.ActionType.IMPORT_TEXTURES_LIBRARY, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_NAME, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_WIDTH, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_HEIGHT, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DEPTH, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_X, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_Y, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ELEVATION, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ANGLE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_COLOR, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TEXTURE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MOVABILITY, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TYPE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VISIBILITY, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER, this.home.getFurnitureSortedProperty() != null);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_NAME, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_WIDTH, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DEPTH, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_HEIGHT, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_X, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_Y, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ELEVATION, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ANGLE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_COLOR, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_TEXTURE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MOVABLE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DOOR_OR_WINDOW, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VISIBLE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED, true);
        homeView.setEnabled(HomeView.ActionType.SELECT, true);
        homeView.setEnabled(HomeView.ActionType.PAN, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_WALLS, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_ROOMS, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_DIMENSION_LINES, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_LABELS, true);
        homeView.setEnabled(HomeView.ActionType.LOCK_BASE_PLAN, true);
        homeView.setEnabled(HomeView.ActionType.UNLOCK_BASE_PLAN, true);
        homeView.setEnabled(HomeView.ActionType.MODIFY_COMPASS, true);
        homeView.setEnabled(HomeView.ActionType.IMPORT_BACKGROUND_IMAGE, true);
        BackgroundImage backgroundImage = this.home.getBackgroundImage();
        boolean bl2 = backgroundImage != null;
        homeView.setEnabled(HomeView.ActionType.MODIFY_BACKGROUND_IMAGE, bl2);
        homeView.setEnabled(HomeView.ActionType.HIDE_BACKGROUND_IMAGE, bl2 && backgroundImage.isVisible());
        homeView.setEnabled(HomeView.ActionType.SHOW_BACKGROUND_IMAGE, bl2 && !backgroundImage.isVisible());
        homeView.setEnabled(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, bl2);
        homeView.setEnabled(HomeView.ActionType.ZOOM_IN, true);
        homeView.setEnabled(HomeView.ActionType.ZOOM_OUT, true);
        homeView.setEnabled(HomeView.ActionType.EXPORT_TO_SVG, true);
        homeView.setEnabled(HomeView.ActionType.VIEW_FROM_TOP, true);
        homeView.setEnabled(HomeView.ActionType.VIEW_FROM_OBSERVER, true);
        homeView.setEnabled(HomeView.ActionType.STORE_POINT_OF_VIEW, true);
        homeView.setEnabled(HomeView.ActionType.DETACH_3D_VIEW, true);
        homeView.setEnabled(HomeView.ActionType.ATTACH_3D_VIEW, true);
        homeView.setEnabled(HomeView.ActionType.VIEW_FROM_OBSERVER, true);
        homeView.setEnabled(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_PHOTO, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_VIDEO, true);
        homeView.setEnabled(HomeView.ActionType.EXPORT_TO_OBJ, true);
        homeView.setEnabled(HomeView.ActionType.HELP, true);
        homeView.setEnabled(HomeView.ActionType.ABOUT, true);
        homeView.setTransferEnabled(true);
    }

    @Override
    public HomeView getView() {
        if (this.homeView == null) {
            this.homeView = this.viewFactory.createHomeView(this.home, this.preferences, this);
            this.enableDefaultActions(this.homeView);
            this.addListeners();
        }
        return this.homeView;
    }

    public List<Plugin> getPlugins() {
        if (this.application != null && this.pluginManager != null) {
            return this.pluginManager.getPlugins(this.application, this.home, this.preferences, this.getUndoableEditSupport());
        }
        List<Plugin> list = Collections.emptyList();
        return list;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public FurnitureCatalogController getFurnitureCatalogController() {
        if (this.furnitureCatalogController == null) {
            this.furnitureCatalogController = new FurnitureCatalogController(this.preferences.getFurnitureCatalog(), this.preferences, this.viewFactory, this.contentManager);
        }
        return this.furnitureCatalogController;
    }

    public FurnitureController getFurnitureController() {
        if (this.furnitureController == null) {
            this.furnitureController = new FurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport());
        }
        return this.furnitureController;
    }

    public PlanController getPlanController() {
        if (this.planController == null) {
            this.planController = new PlanController(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport());
        }
        return this.planController;
    }

    public HomeController3D getHomeController3D() {
        if (this.homeController3D == null) {
            this.homeController3D = new HomeController3D(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport());
        }
        return this.homeController3D;
    }

    protected final UndoableEditSupport getUndoableEditSupport() {
        return this.undoSupport;
    }

    private void addListeners() {
        this.preferences.getFurnitureCatalog().addFurnitureListener(new FurnitureCatalogChangeListener(this));
        this.preferences.getTexturesCatalog().addTexturesListener(new TexturesCatalogChangeListener(this));
        UserPreferencesPropertiesChangeListener userPreferencesPropertiesChangeListener = new UserPreferencesPropertiesChangeListener(this);
        for (UserPreferences.Property property : UserPreferences.Property.values()) {
            this.preferences.addPropertyChangeListener(property, userPreferencesPropertiesChangeListener);
        }
        this.addCatalogSelectionListener();
        this.addHomeBackgroundImageListener();
        this.addNotUndoableModificationListeners();
        this.addHomeSelectionListener();
        this.addFurnitureSortListener();
        this.addUndoSupportListener();
        this.addHomeItemsListener();
        this.addPlanControllerListeners();
        this.addLanguageListener();
    }

    private void addCatalogSelectionListener() {
        this.getFurnitureCatalogController().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                HomeController.this.enableActionsBoundToSelection();
            }
        });
    }

    private void addLanguageListener() {
        this.preferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void addHomeSelectionListener() {
        if (this.home != null) {
            this.home.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent selectionEvent) {
                    HomeController.this.enableActionsBoundToSelection();
                }
            });
        }
    }

    private void addFurnitureSortListener() {
        if (this.home != null) {
            this.home.addPropertyChangeListener(Home.Property.FURNITURE_SORTED_PROPERTY, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeController.this.getView().setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER, propertyChangeEvent.getNewValue() != null);
                }
            });
        }
    }

    private void addHomeBackgroundImageListener() {
        if (this.home != null) {
            this.home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BackgroundImage backgroundImage = (BackgroundImage)propertyChangeEvent.getNewValue();
                    boolean bl = backgroundImage != null;
                    HomeController.this.getView().setEnabled(HomeView.ActionType.MODIFY_BACKGROUND_IMAGE, bl);
                    HomeController.this.getView().setEnabled(HomeView.ActionType.HIDE_BACKGROUND_IMAGE, bl && backgroundImage.isVisible());
                    HomeController.this.getView().setEnabled(HomeView.ActionType.SHOW_BACKGROUND_IMAGE, bl && !backgroundImage.isVisible());
                    HomeController.this.getView().setEnabled(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, bl);
                }
            });
        }
    }

    private void addNotUndoableModificationListeners() {
        if (this.home != null) {
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeController.this.notUndoableModifications = true;
                    HomeController.this.home.setModified(true);
                }
            };
            this.home.addPropertyChangeListener(Home.Property.STORED_CAMERAS, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_WIDTH, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_ASPECT_RATIO, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_FRAME_RATE, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_QUALITY, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_CAMERA_PATH, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_QUALITY, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_ASPECT_RATIO, propertyChangeListener);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (HomeController.this.home.getEnvironment().getPhotoAspectRatio() != AspectRatio.VIEW_3D_RATIO) {
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_WIDTH, propertyChangeListener2);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_HEIGHT, propertyChangeListener2);
            PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(Camera.Property.TIME.name()) || propertyChangeEvent.getPropertyName().equals(Camera.Property.LENS.name())) {
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }
            };
            this.home.getObserverCamera().addPropertyChangeListener(propertyChangeListener3);
            this.home.getTopCamera().addPropertyChangeListener(propertyChangeListener3);
        }
    }

    protected void enableActionsBoundToSelection() {
        List<HomePieceOfFurniture> list;
        boolean bl = this.getPlanController().isModificationState();
        List<CatalogPieceOfFurniture> list2 = this.getFurnitureCatalogController().getSelectedFurniture();
        boolean bl2 = !list2.isEmpty();
        boolean bl3 = list2.size() == 1 && list2.get(0).isModifiable();
        List<Selectable> list3 = this.home.getSelectedItems();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        FurnitureController furnitureController = this.getFurnitureController();
        if (!bl) {
            List<Wall> list4;
            list = list3.iterator();
            while (list.hasNext()) {
                Iterator<HomePieceOfFurniture> iterator = (Selectable)list.next();
                if (!this.getPlanController().isItemDeletable((Selectable)((Object)iterator))) continue;
                bl4 = true;
                break;
            }
            bl5 = !(list = Home.getFurnitureSubList(list3)).isEmpty();
            for (HomePieceOfFurniture object2 : list) {
                if (!furnitureController.isPieceOfFurnitureDeletable(object2)) continue;
                bl6 = true;
                break;
            }
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                bl9 = true;
                break;
            }
            int n = 0;
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!furnitureController.isPieceOfFurnitureMovable(homePieceOfFurniture) || ++n < 2) continue;
                bl8 = true;
                break;
            }
            bl10 = !(list4 = Home.getWallsSubList(list3)).isEmpty();
            bl12 = list4.size() == 1;
            bl11 = !Home.getRoomsSubList(list3).isEmpty();
            boolean bl16 = !Home.getDimensionLinesSubList(list3).isEmpty();
            List<Label> list5 = Home.getLabelsSubList(list3);
            boolean bl17 = !list5.isEmpty();
            bl15 = list3.contains(this.home.getCompass());
            bl13 = list5.size() == 1;
            bl7 = bl5 || bl10 || bl11 || bl16 || bl17 || bl15;
            bl14 = bl5 || bl11 || bl16 || bl17;
        }
        list = this.getView();
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            list.setEnabled(HomeView.ActionType.COPY, !bl && bl2);
            list.setEnabled(HomeView.ActionType.CUT, false);
            list.setEnabled(HomeView.ActionType.DELETE, false);
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : list2) {
                if (!catalogPieceOfFurniture.isModifiable()) continue;
                list.setEnabled(HomeView.ActionType.DELETE, true);
                break;
            }
        } else if (this.focusedView == furnitureController.getView()) {
            list.setEnabled(HomeView.ActionType.COPY, bl5);
            list.setEnabled(HomeView.ActionType.CUT, bl6);
            list.setEnabled(HomeView.ActionType.DELETE, bl6);
        } else if (this.focusedView == this.getPlanController().getView()) {
            list.setEnabled(HomeView.ActionType.COPY, bl7);
            list.setEnabled(HomeView.ActionType.CUT, bl4);
            list.setEnabled(HomeView.ActionType.DELETE, bl4);
        } else {
            list.setEnabled(HomeView.ActionType.COPY, false);
            list.setEnabled(HomeView.ActionType.CUT, false);
            list.setEnabled(HomeView.ActionType.DELETE, false);
        }
        list.setEnabled(HomeView.ActionType.ADD_HOME_FURNITURE, bl2);
        list.setEnabled(HomeView.ActionType.DELETE_HOME_FURNITURE, bl6);
        list.setEnabled(HomeView.ActionType.DELETE_SELECTION, bl2 && this.focusedView == this.getFurnitureCatalogController().getView() || bl4 && (this.focusedView == furnitureController.getView() || this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()));
        list.setEnabled(HomeView.ActionType.MODIFY_FURNITURE, bl3 && this.focusedView == this.getFurnitureCatalogController().getView() || bl5 && (this.focusedView == furnitureController.getView() || this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()));
        list.setEnabled(HomeView.ActionType.MODIFY_WALL, bl10);
        list.setEnabled(HomeView.ActionType.REVERSE_WALL_DIRECTION, bl10);
        list.setEnabled(HomeView.ActionType.SPLIT_WALL, bl12);
        list.setEnabled(HomeView.ActionType.MODIFY_ROOM, bl11);
        list.setEnabled(HomeView.ActionType.MODIFY_LABEL, bl13);
        list.setEnabled(HomeView.ActionType.TOGGLE_BOLD_STYLE, bl14);
        list.setEnabled(HomeView.ActionType.TOGGLE_ITALIC_STYLE, bl14);
        list.setEnabled(HomeView.ActionType.INCREASE_TEXT_SIZE, bl14);
        list.setEnabled(HomeView.ActionType.DECREASE_TEXT_SIZE, bl14);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, bl8);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, bl8);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, bl8);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, bl8);
        list.setEnabled(HomeView.ActionType.GROUP_FURNITURE, bl8);
        list.setEnabled(HomeView.ActionType.UNGROUP_FURNITURE, bl9);
    }

    public void enablePasteAction() {
        HomeView homeView = this.getView();
        if (this.focusedView == this.getFurnitureController().getView() || this.focusedView == this.getPlanController().getView()) {
            homeView.setEnabled(HomeView.ActionType.PASTE, !this.getPlanController().isModificationState() && !homeView.isClipboardEmpty());
        } else {
            homeView.setEnabled(HomeView.ActionType.PASTE, false);
        }
    }

    protected void enableSelectAllAction() {
        HomeView homeView = this.getView();
        boolean bl = this.getPlanController().isModificationState();
        if (this.focusedView == this.getFurnitureController().getView()) {
            homeView.setEnabled(HomeView.ActionType.SELECT_ALL, !bl && this.home.getFurniture().size() > 0);
        } else if (this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()) {
            boolean bl2 = !this.home.isEmpty() || this.home.getCompass().isVisible();
            homeView.setEnabled(HomeView.ActionType.SELECT_ALL, !bl && bl2);
        } else {
            homeView.setEnabled(HomeView.ActionType.SELECT_ALL, false);
        }
    }

    private void enableZoomActions() {
        PlanController planController = this.getPlanController();
        float f = planController.getScale();
        HomeView homeView = this.getView();
        homeView.setEnabled(HomeView.ActionType.ZOOM_IN, f < planController.getMaximumScale());
        homeView.setEnabled(HomeView.ActionType.ZOOM_OUT, f > planController.getMinimumScale());
    }

    private void addUndoSupportListener() {
        this.getUndoableEditSupport().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                HomeView homeView = HomeController.this.getView();
                homeView.setEnabled(HomeView.ActionType.UNDO, !HomeController.this.getPlanController().isModificationState());
                homeView.setEnabled(HomeView.ActionType.REDO, false);
                homeView.setUndoRedoName(undoableEditEvent.getEdit().getUndoPresentationName(), null);
                HomeController.this.saveUndoLevel++;
                HomeController.this.home.setModified(true);
            }
        });
        this.home.addPropertyChangeListener(Home.Property.MODIFIED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!HomeController.this.home.isModified()) {
                    HomeController.this.saveUndoLevel = 0;
                    HomeController.this.notUndoableModifications = false;
                }
            }
        });
    }

    private void addHomeItemsListener() {
        CollectionListener collectionListener = new CollectionListener(){

            public void collectionChanged(CollectionEvent collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD || collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    HomeController.this.enableSelectAllAction();
                }
            }
        };
        this.home.addFurnitureListener(collectionListener);
        this.home.addWallsListener(collectionListener);
        this.home.addRoomsListener(collectionListener);
        this.home.addDimensionLinesListener(collectionListener);
        this.home.addLabelsListener(collectionListener);
        this.home.getCompass().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Compass.Property.VISIBLE.equals(propertyChangeEvent.getPropertyName())) {
                    HomeController.this.enableSelectAllAction();
                }
            }
        });
    }

    private void addPlanControllerListeners() {
        this.getPlanController().addPropertyChangeListener(PlanController.Property.MODIFICATION_STATE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController.this.enableActionsBoundToSelection();
                HomeController.this.enableSelectAllAction();
                HomeView homeView = HomeController.this.getView();
                if (HomeController.this.getPlanController().isModificationState()) {
                    homeView.setEnabled(HomeView.ActionType.PASTE, false);
                    homeView.setEnabled(HomeView.ActionType.UNDO, false);
                    homeView.setEnabled(HomeView.ActionType.REDO, false);
                } else {
                    HomeController.this.enablePasteAction();
                    homeView.setEnabled(HomeView.ActionType.UNDO, HomeController.this.undoManager.canUndo());
                    homeView.setEnabled(HomeView.ActionType.REDO, HomeController.this.undoManager.canRedo());
                }
            }
        });
        this.getPlanController().addPropertyChangeListener(PlanController.Property.SCALE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController.this.enableZoomActions();
            }
        });
    }

    public void addHomeFurniture() {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        List<CatalogPieceOfFurniture> list = this.getFurnitureCatalogController().getSelectedFurniture();
        if (!list.isEmpty()) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
                HomePieceOfFurniture homePieceOfFurniture = catalogPieceOfFurniture instanceof CatalogDoorOrWindow ? new HomeDoorOrWindow((DoorOrWindow)((Object)catalogPieceOfFurniture)) : (catalogPieceOfFurniture instanceof CatalogLight ? new HomeLight((Light)((Object)catalogPieceOfFurniture)) : new HomePieceOfFurniture(catalogPieceOfFurniture));
                if (this.preferences.isMagnetismEnabled()) {
                    if (homePieceOfFurniture.isResizable()) {
                        homePieceOfFurniture.setWidth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getWidth(), 0.1f));
                        homePieceOfFurniture.setDepth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getDepth(), 0.1f));
                        homePieceOfFurniture.setHeight(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getHeight(), 0.1f));
                    }
                    homePieceOfFurniture.setElevation(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getElevation(), 0.1f));
                }
                arrayList.add(homePieceOfFurniture);
            }
            this.getFurnitureController().addFurniture(arrayList);
        }
    }

    public void modifySelectedFurniture() {
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            this.getFurnitureCatalogController().modifySelectedFurniture();
        } else if (this.focusedView == this.getFurnitureController().getView() || this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()) {
            this.getFurnitureController().modifySelectedFurniture();
        }
    }

    public void importLanguageLibrary(String string) {
        try {
            if (!this.preferences.languageLibraryExists(string) || this.getView().confirmReplaceLanguageLibrary(string)) {
                this.preferences.addLanguageLibrary(string);
            }
        }
        catch (RecorderException recorderException) {
            String string2 = this.preferences.getLocalizedString(HomeController.class, "importLanguageLibraryError", string);
            this.getView().showError(string2);
        }
    }

    public void importFurniture() {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            this.getFurnitureCatalogController().importFurniture();
        } else {
            this.getFurnitureController().importFurniture();
        }
    }

    public void importFurnitureLibrary() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showImportFurnitureLibraryDialog();
                if (string != null) {
                    HomeController.this.importFurnitureLibrary(string);
                }
            }
        });
    }

    public void importFurnitureLibrary(String string) {
        try {
            if (!this.preferences.furnitureLibraryExists(string) || this.getView().confirmReplaceFurnitureLibrary(string)) {
                this.preferences.addFurnitureLibrary(string);
            }
        }
        catch (RecorderException recorderException) {
            String string2 = this.preferences.getLocalizedString(HomeController.class, "importFurnitureLibraryError", string);
            this.getView().showError(string2);
        }
    }

    public void importTexturesLibrary() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showImportTexturesLibraryDialog();
                if (string != null) {
                    HomeController.this.importTexturesLibrary(string);
                }
            }
        });
    }

    public void importTexturesLibrary(String string) {
        try {
            if (!this.preferences.texturesLibraryExists(string) || this.getView().confirmReplaceTexturesLibrary(string)) {
                this.preferences.addTexturesLibrary(string);
            }
        }
        catch (RecorderException recorderException) {
            String string2 = this.preferences.getLocalizedString(HomeController.class, "importTexturesLibraryError", string);
            this.getView().showError(string2);
        }
    }

    public void importPlugin(String string) {
        if (this.pluginManager != null) {
            try {
                if (!this.pluginManager.pluginExists(string) || this.getView().confirmReplacePlugin(string)) {
                    this.pluginManager.addPlugin(string);
                    this.getView().showMessage(this.preferences.getLocalizedString(HomeController.class, "importedPluginMessage", new Object[0]));
                }
            }
            catch (RecorderException recorderException) {
                String string2 = this.preferences.getLocalizedString(HomeController.class, "importPluginError", string);
                this.getView().showError(string2);
            }
        }
    }

    public void undo() {
        this.undoManager.undo();
        HomeView homeView = this.getView();
        boolean bl = this.undoManager.canUndo();
        homeView.setEnabled(HomeView.ActionType.UNDO, bl);
        homeView.setEnabled(HomeView.ActionType.REDO, true);
        if (bl) {
            homeView.setUndoRedoName(this.undoManager.getUndoPresentationName(), this.undoManager.getRedoPresentationName());
        } else {
            homeView.setUndoRedoName(null, this.undoManager.getRedoPresentationName());
        }
        --this.saveUndoLevel;
        this.home.setModified(this.saveUndoLevel != 0 || this.notUndoableModifications);
    }

    public void redo() {
        this.undoManager.redo();
        HomeView homeView = this.getView();
        boolean bl = this.undoManager.canRedo();
        homeView.setEnabled(HomeView.ActionType.UNDO, true);
        homeView.setEnabled(HomeView.ActionType.REDO, bl);
        if (bl) {
            homeView.setUndoRedoName(this.undoManager.getUndoPresentationName(), this.undoManager.getRedoPresentationName());
        } else {
            homeView.setUndoRedoName(this.undoManager.getUndoPresentationName(), null);
        }
        ++this.saveUndoLevel;
        this.home.setModified(this.saveUndoLevel != 0 || this.notUndoableModifications);
    }

    public void cut(List<? extends Selectable> list) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        undoableEditSupport.beginUpdate();
        this.getPlanController().deleteItems(list);
        undoableEditSupport.postEdit(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoCutName", new Object[0]);
            }
        });
        undoableEditSupport.endUpdate();
    }

    public void paste(List<? extends Selectable> list) {
        List<Selectable> list2 = this.home.getSelectedItems();
        float f = 0.0f;
        if (list.size() == list2.size()) {
            f = 20.0f;
            for (Selectable selectable : list) {
                float[][] fArray = selectable.getPoints();
                boolean bl = false;
                for (Selectable selectable2 : list2) {
                    if (!Arrays.deepEquals((Object[])fArray, (Object[])selectable2.getPoints())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                f = 0.0f;
                break;
            }
        }
        this.addItems(list, f, f, false, "undoPasteName");
    }

    public void drop(List<? extends Selectable> list, float f, float f2) {
        this.drop(list, null, f, f2);
    }

    public void drop(List<? extends Selectable> list, View view, float f, float f2) {
        this.addItems(list, f, f2, view == this.getPlanController().getView(), "undoDropName");
    }

    private void addItems(final List<? extends Selectable> list, float f, float f2, boolean bl, final String string) {
        if (list.size() > 1 || list.size() == 1 && !(list.get(0) instanceof Compass)) {
            this.getPlanController().setMode(PlanController.Mode.SELECTION);
            UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
            undoableEditSupport.beginUpdate();
            List<HomePieceOfFurniture> list2 = Home.getFurnitureSubList(list);
            if (this.preferences.isMagnetismEnabled()) {
                for (HomePieceOfFurniture homePieceOfFurniture : list2) {
                    if (homePieceOfFurniture.isResizable()) {
                        homePieceOfFurniture.setWidth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getWidth(), 0.1f));
                        homePieceOfFurniture.setDepth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getDepth(), 0.1f));
                        homePieceOfFurniture.setHeight(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getHeight(), 0.1f));
                    }
                    homePieceOfFurniture.setElevation(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getElevation(), 0.1f));
                }
            }
            this.getPlanController().moveItems(list, f, f2);
            if (bl && this.preferences.isMagnetismEnabled() && list.size() == 1 && list2.size() == 1) {
                this.getPlanController().adjustMagnetizedPieceOfFurniture((HomePieceOfFurniture)list.get(0), f, f2);
            }
            this.getPlanController().addFurniture(list2);
            this.getPlanController().addWalls(Home.getWallsSubList(list));
            this.getPlanController().addRooms(Home.getRoomsSubList(list));
            this.getPlanController().addDimensionLines(Home.getDimensionLinesSubList(list));
            this.getPlanController().addLabels(Home.getLabelsSubList(list));
            this.home.setSelectedItems(list);
            undoableEditSupport.postEdit(new AbstractUndoableEdit(){

                public void redo() throws CannotRedoException {
                    super.redo();
                    HomeController.this.home.setSelectedItems(list);
                }

                public String getPresentationName() {
                    return HomeController.this.preferences.getLocalizedString(HomeController.class, string, new Object[0]);
                }
            });
            undoableEditSupport.endUpdate();
        }
    }

    public void dropFiles(List<String> list, float f, float f2) {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        final ArrayList arrayList = new ArrayList(list.size());
        CollectionListener<HomePieceOfFurniture> collectionListener = new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                arrayList.add(collectionEvent.getItem());
            }
        };
        this.home.addFurnitureListener(collectionListener);
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        undoableEditSupport.beginUpdate();
        for (String string : list) {
            this.getFurnitureController().importFurniture(string);
        }
        this.home.removeFurnitureListener(collectionListener);
        if (arrayList.size() > 0) {
            this.getPlanController().moveItems(arrayList, f, f2);
            this.home.setSelectedItems(arrayList);
            undoableEditSupport.postEdit(new AbstractUndoableEdit(){

                public void redo() throws CannotRedoException {
                    super.redo();
                    HomeController.this.home.setSelectedItems(arrayList);
                }

                public String getPresentationName() {
                    return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoDropName", new Object[0]);
                }
            });
        }
        undoableEditSupport.endUpdate();
    }

    public void delete() {
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            if (this.getView().confirmDeleteCatalogSelection()) {
                this.getFurnitureCatalogController().deleteSelection();
            }
        } else if (this.focusedView == this.getFurnitureController().getView()) {
            this.getFurnitureController().deleteSelection();
        } else if (this.focusedView == this.getPlanController().getView()) {
            this.getPlanController().deleteSelection();
        }
    }

    public void focusedViewChanged(View view) {
        this.focusedView = view;
        this.enableActionsBoundToSelection();
        this.enablePasteAction();
        this.enableSelectAllAction();
    }

    public void selectAll() {
        if (this.focusedView == this.getFurnitureController().getView()) {
            this.getFurnitureController().selectAll();
        } else if (this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()) {
            this.getPlanController().selectAll();
        }
    }

    public void newHome() {
        Home home = this.application != null ? this.application.createHome() : new Home(this.preferences.getNewWallHeight());
        this.application.addHome(home);
    }

    public void open() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showOpenDialog();
                if (string != null) {
                    HomeController.this.open(string);
                }
            }
        });
    }

    public void open(final String string) {
        for (Home object2 : this.application.getHomes()) {
            if (!string.equals(object2.getName())) continue;
            String string2 = this.preferences.getLocalizedString(HomeController.class, "alreadyOpen", string);
            this.getView().showMessage(string2);
            return;
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws RecorderException {
                Home home = HomeController.this.application.getHomeRecorder().readHome(string);
                home.setName(string);
                HomeController.this.addHomeToApplication(home);
                return null;
            }
        };
        ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

            public void handleException(Exception exception) {
                if (!(exception instanceof InterruptedRecorderException)) {
                    if (exception instanceof RecorderException) {
                        String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "openError", string);
                        HomeController.this.getView().showError(string2);
                    } else {
                        exception.printStackTrace();
                    }
                }
            }
        };
        new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "openMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
    }

    private void addHomeToApplication(final Home home) {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                HomeController.this.application.addHome(home);
            }
        });
    }

    private void updateUserPreferencesRecentHomes(List<String> list) {
        if (this.application != null) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    if (this.application.getHomeRecorder().exists(iterator.next())) continue;
                    iterator.remove();
                }
                catch (RecorderException recorderException) {}
            }
            this.preferences.setRecentHomes(list);
        }
    }

    public List<String> getRecentHomes() {
        if (this.application != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.preferences.getRecentHomes()) {
                try {
                    if (!this.application.getHomeRecorder().exists(string)) continue;
                    arrayList.add(string);
                    if (arrayList.size() != this.preferences.getRecentHomesMaxCount()) continue;
                    break;
                }
                catch (RecorderException recorderException) {
                }
            }
            this.getView().setEnabled(HomeView.ActionType.DELETE_RECENT_HOMES, !arrayList.isEmpty());
            return Collections.unmodifiableList(arrayList);
        }
        return new ArrayList<String>();
    }

    public String getVersion() {
        if (this.application != null) {
            return this.application.getVersion();
        }
        return "";
    }

    public void deleteRecentHomes() {
        this.updateUserPreferencesRecentHomes(new ArrayList<String>());
        this.getView().setEnabled(HomeView.ActionType.DELETE_RECENT_HOMES, false);
    }

    public void close() {
        this.close(null);
    }

    protected void close(final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            public void run() {
                HomeController.this.home.setRecovered(false);
                HomeController.this.application.deleteHome(HomeController.this.home);
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        if (this.home.isModified() || this.home.isRecovered()) {
            switch (this.getView().confirmSave(this.home.getName())) {
                case SAVE: {
                    this.save(HomeRecorder.Type.DEFAULT, runnable2);
                }
                case CANCEL: {
                    return;
                }
            }
        }
        runnable2.run();
    }

    public void save() {
        this.save(HomeRecorder.Type.DEFAULT, null);
    }

    private void save(HomeRecorder.Type type, Runnable runnable) {
        if (this.home.getName() == null) {
            this.saveAs(type, runnable);
        } else {
            this.save(this.home.getName(), type, runnable);
        }
    }

    public void saveAs() {
        this.saveAs(HomeRecorder.Type.DEFAULT, null);
    }

    private void saveAs(HomeRecorder.Type type, Runnable runnable) {
        String string = this.getView().showSaveDialog(this.home.getName());
        if (string != null) {
            this.save(string, type, runnable);
        }
    }

    public void saveAndCompress() {
        this.save(HomeRecorder.Type.COMPRESSED, null);
    }

    private void save(final String string, final HomeRecorder.Type type, final Runnable runnable) {
        if (this.home.getVersion() <= 3300L || !string.equals(this.home.getName()) || this.getView().confirmSaveNewerHome(string)) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.application.getHomeRecorder(type).writeHome(HomeController.this.home, string);
                    HomeController.this.updateSavedHome(string, runnable);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "saveError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "saveMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    private void updateSavedHome(final String string, final Runnable runnable) {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                HomeController.this.home.setName(string);
                HomeController.this.home.setModified(false);
                HomeController.this.home.setRecovered(false);
                ArrayList<String> arrayList = new ArrayList<String>(HomeController.this.preferences.getRecentHomes());
                int n = arrayList.indexOf(string);
                if (n >= 0) {
                    arrayList.remove(n);
                }
                arrayList.add(0, string);
                HomeController.this.updateUserPreferencesRecentHomes(arrayList);
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public void exportToSVG() {
        final String string = this.getView().showExportToSVGDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().exportToSVG(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "exportToSVGError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "exportToSVGMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void exportToOBJ() {
        final String string = this.getView().showExportToOBJDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().exportToOBJ(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "exportToOBJError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "exportToOBJMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void createPhoto() {
        PhotoController photoController = new PhotoController(this.home, this.preferences, this.getHomeController3D().getView(), this.viewFactory, this.contentManager);
        photoController.displayView(this.getView());
    }

    public void createVideo() {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        this.getHomeController3D().viewFromObserver();
        VideoController videoController = new VideoController(this.home, this.preferences, this.viewFactory, this.contentManager);
        videoController.displayView(this.getView());
    }

    public void setupPage() {
        new PageSetupController(this.home, this.preferences, this.viewFactory, this.getUndoableEditSupport()).displayView(this.getView());
    }

    public void previewPrint() {
        new PrintPreviewController(this.home, this.preferences, this, this.viewFactory).displayView(this.getView());
    }

    public void print() {
        Callable<Void> callable = this.getView().showPrintDialog();
        if (callable != null) {
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string = HomeController.this.preferences.getLocalizedString(HomeController.class, "printError", HomeController.this.home.getName());
                            HomeController.this.getView().showError(string);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "printMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void printToPDF() {
        final String string = this.getView().showPrintToPDFDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().printToPDF(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "printToPDFError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "printToPDFMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void exit() {
        for (Home home : this.application.getHomes()) {
            if (!home.isModified() && !home.isRecovered()) continue;
            if (this.getView().confirmExit()) break;
            return;
        }
        for (Home home : this.application.getHomes()) {
            home.setRecovered(false);
            this.application.deleteHome(home);
        }
    }

    public void editPreferences() {
        new UserPreferencesController(this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
    }

    public void setMode(PlanController.Mode mode) {
        if (this.getPlanController().getMode() != mode) {
            final String string = mode == PlanController.Mode.WALL_CREATION ? HomeView.ActionType.CREATE_WALLS.name() : (mode == PlanController.Mode.ROOM_CREATION ? HomeView.ActionType.CREATE_ROOMS.name() : (mode == PlanController.Mode.DIMENSION_LINE_CREATION ? HomeView.ActionType.CREATE_DIMENSION_LINES.name() : (mode == PlanController.Mode.LABEL_CREATION ? HomeView.ActionType.CREATE_LABELS.name() : null)));
            if (string != null && !this.preferences.isActionTipIgnored(string)) {
                this.getView().invokeLater(new Runnable(){

                    public void run() {
                        if (HomeController.this.getView().showActionTipMessage(string)) {
                            HomeController.this.preferences.setActionTipIgnored(string);
                        }
                    }
                });
            }
            this.getPlanController().setMode(mode);
        }
    }

    public void importBackgroundImage() {
        new BackgroundImageWizardController(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport()).displayView(this.getView());
    }

    public void modifyBackgroundImage() {
        this.importBackgroundImage();
    }

    public void hideBackgroundImage() {
        this.toggleBackgroundImageVisibility("undoHideBackgroundImageName");
    }

    public void showBackgroundImage() {
        this.toggleBackgroundImageVisibility("undoShowBackgroundImageName");
    }

    private void toggleBackgroundImageVisibility(final String string) {
        this.doToggleBackgroundImageVisibility();
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                HomeController.this.doToggleBackgroundImageVisibility();
            }

            public void redo() throws CannotRedoException {
                super.redo();
                HomeController.this.doToggleBackgroundImageVisibility();
            }

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, string, new Object[0]);
            }
        };
        this.getUndoableEditSupport().postEdit(abstractUndoableEdit);
    }

    private void doToggleBackgroundImageVisibility() {
        BackgroundImage backgroundImage = this.home.getBackgroundImage();
        this.home.setBackgroundImage(new BackgroundImage(backgroundImage.getImage(), backgroundImage.getScaleDistance(), backgroundImage.getScaleDistanceXStart(), backgroundImage.getScaleDistanceYStart(), backgroundImage.getScaleDistanceXEnd(), backgroundImage.getScaleDistanceYEnd(), backgroundImage.getXOrigin(), backgroundImage.getYOrigin(), !backgroundImage.isVisible()));
    }

    public void deleteBackgroundImage() {
        final BackgroundImage backgroundImage = this.home.getBackgroundImage();
        this.home.setBackgroundImage(null);
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                HomeController.this.home.setBackgroundImage(backgroundImage);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                HomeController.this.home.setBackgroundImage(null);
            }

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoDeleteBackgroundImageName", new Object[0]);
            }
        };
        this.getUndoableEditSupport().postEdit(abstractUndoableEdit);
    }

    public void zoomOut() {
        PlanController planController = this.getPlanController();
        float f = planController.getScale() / 1.5f;
        planController.setScale(f);
    }

    public void zoomIn() {
        PlanController planController = this.getPlanController();
        float f = planController.getScale() * 1.5f;
        planController.setScale(f);
    }

    public void storeCamera() {
        String string = DateFormat.getDateTimeInstance(3, 2).format(new Date());
        String string2 = this.getView().showStoreCameraDialog(string);
        if (string2 != null) {
            this.getHomeController3D().storeCamera(string2);
        }
    }

    public void detachView(View view) {
        if (view != null) {
            this.getView().detachView(view);
            this.notUndoableModifications = true;
            this.home.setModified(true);
        }
    }

    public void attachView(View view) {
        if (view != null) {
            this.getView().attachView(view);
            this.notUndoableModifications = true;
            this.home.setModified(true);
        }
    }

    public void help() {
        if (helpController == null) {
            helpController = new HelpController(this.preferences, this.viewFactory);
        }
        helpController.displayView();
    }

    public void about() {
        this.getView().showAboutDialog();
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomeController> homeController;

        public LanguageChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                homeController.getView().setUndoRedoName(homeController.undoManager.canUndo() ? homeController.undoManager.getUndoPresentationName() : null, homeController.undoManager.canRedo() ? homeController.undoManager.getRedoPresentationName() : null);
            }
        }
    }

    private static class UserPreferencesPropertiesChangeListener
    extends UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomeController> homeController;

        public UserPreferencesPropertiesChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                this.writePreferences(homeController);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TexturesCatalogChangeListener
    extends UserPreferencesChangeListener
    implements CollectionListener<CatalogTexture> {
        private WeakReference<HomeController> homeController;

        public TexturesCatalogChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogTexture> collectionEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((TexturesCatalog)collectionEvent.getSource()).removeTexturesListener(this);
            } else {
                this.writePreferences(homeController);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureCatalogChangeListener
    extends UserPreferencesChangeListener
    implements CollectionListener<CatalogPieceOfFurniture> {
        private WeakReference<HomeController> homeController;

        public FurnitureCatalogChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((FurnitureCatalog)collectionEvent.getSource()).removeFurnitureListener(this);
            } else {
                this.writePreferences(homeController);
            }
        }
    }

    private static abstract class UserPreferencesChangeListener {
        private static Set<UserPreferences> writingPreferences = new HashSet<UserPreferences>();

        private UserPreferencesChangeListener() {
        }

        public void writePreferences(final HomeController homeController) {
            if (!writingPreferences.contains(homeController.preferences)) {
                writingPreferences.add(homeController.preferences);
                homeController.getView().invokeLater(new Runnable(){

                    public void run() {
                        try {
                            homeController.preferences.write();
                            writingPreferences.remove(homeController.preferences);
                        }
                        catch (RecorderException recorderException) {
                            homeController.getView().showError(homeController.preferences.getLocalizedString(HomeController.class, "savePreferencesError", new Object[0]));
                        }
                    }
                });
            }
        }
    }
}

