/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;

public class PhotoController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final View view3D;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private final CameraChangeListener cameraChangeListener;
    private DialogView photoView;
    private AspectRatio aspectRatio;
    private int width;
    private int height;
    private int quality;
    private float view3DAspectRatio;
    private long time;
    private Camera.Lens lens;
    private int ceilingLightColor;

    public PhotoController(Home home, UserPreferences userPreferences, View view, ViewFactory viewFactory, ContentManager contentManager) {
        this.home = home;
        this.preferences = userPreferences;
        this.view3D = view;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.cameraChangeListener = new CameraChangeListener(this);
        home.getCamera().addPropertyChangeListener(this.cameraChangeListener);
        home.addPropertyChangeListener(Home.Property.CAMERA, new HomeCameraChangeListener(this));
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, new HomeEnvironmentChangeListener(this));
        this.updateProperties();
    }

    public DialogView getView() {
        if (this.photoView == null) {
            this.photoView = this.viewFactory.createPhotoView(this.home, this.preferences, this);
        }
        return this.photoView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        this.setAspectRatio(homeEnvironment.getPhotoAspectRatio());
        this.setWidth(homeEnvironment.getPhotoWidth(), false);
        this.setHeight(homeEnvironment.getPhotoHeight(), false);
        this.setQuality(homeEnvironment.getPhotoQuality());
        this.setTime(this.home.getCamera().getTime());
        this.setLens(this.home.getCamera().getLens());
        this.setCeilingLightColor(homeEnvironment.getCeillingLightColor());
        this.view3DAspectRatio = 1.0f;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        if (this.aspectRatio != aspectRatio) {
            AspectRatio aspectRatio2 = this.aspectRatio;
            this.aspectRatio = aspectRatio;
            this.propertyChangeSupport.firePropertyChange(Property.ASPECT_RATIO.name(), (Object)aspectRatio2, (Object)aspectRatio);
            this.home.getEnvironment().setPhotoAspectRatio(this.aspectRatio);
            if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                this.setHeight(Math.round((float)this.width / this.view3DAspectRatio), false);
            } else if (this.aspectRatio.getValue() != null) {
                this.setHeight(Math.round((float)this.width / this.aspectRatio.getValue().floatValue()), false);
            }
        }
    }

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public void setWidth(int n) {
        this.setWidth(n, true);
    }

    private void setWidth(int n, boolean bl) {
        if (this.width != n) {
            int n2 = this.width;
            this.width = n;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), n2, n);
            if (bl) {
                if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                    this.setHeight(Math.round((float)n / this.view3DAspectRatio), false);
                } else if (this.aspectRatio.getValue() != null) {
                    this.setHeight(Math.round((float)n / this.aspectRatio.getValue().floatValue()), false);
                }
            }
            this.home.getEnvironment().setPhotoWidth(this.width);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.setHeight(n, true);
    }

    private void setHeight(int n, boolean bl) {
        if (this.height != n) {
            int n2 = this.height;
            this.height = n;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), n2, n);
            if (bl) {
                if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                    this.setWidth(Math.round((float)n * this.view3DAspectRatio), false);
                } else if (this.aspectRatio.getValue() != null) {
                    this.setWidth(Math.round((float)n * this.aspectRatio.getValue().floatValue()), false);
                }
            }
            this.home.getEnvironment().setPhotoHeight(this.height);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setQuality(int n) {
        if (this.quality != n) {
            int n2 = this.quality;
            this.quality = Math.min(n, this.getQualityLevelCount() - 1);
            this.propertyChangeSupport.firePropertyChange(Property.QUALITY.name(), n2, n);
            this.home.getEnvironment().setPhotoQuality(this.quality);
        }
    }

    public int getQuality() {
        return this.quality;
    }

    public int getQualityLevelCount() {
        return 4;
    }

    public void setTime(long l) {
        if (this.time != l) {
            long l2 = this.time;
            this.time = l;
            this.propertyChangeSupport.firePropertyChange(Property.TIME.name(), l2, l);
            this.home.getCamera().setTime(l);
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setLens(Camera.Lens lens) {
        if (this.lens != lens) {
            Camera.Lens lens2 = this.lens;
            this.lens = lens;
            this.propertyChangeSupport.firePropertyChange(Property.LENS.name(), (Object)lens2, (Object)lens);
            if (lens == Camera.Lens.SPHERICAL) {
                this.setAspectRatio(AspectRatio.RATIO_2_1);
            } else if (lens == Camera.Lens.FISHEYE) {
                this.setAspectRatio(AspectRatio.SQUARE_RATIO);
            }
            this.home.getCamera().setLens(this.lens);
        }
    }

    public Camera.Lens getLens() {
        return this.lens;
    }

    public void setCeilingLightColor(int n) {
        if (this.ceilingLightColor != n) {
            int n2 = this.ceilingLightColor;
            this.ceilingLightColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_LIGHT_COLOR.name(), n2, n);
            this.home.getEnvironment().setCeillingLightColor(n);
        }
    }

    public int getCeilingLightColor() {
        return this.ceilingLightColor;
    }

    public void set3DViewAspectRatio(float f) {
        if (this.view3DAspectRatio != f) {
            float f2 = this.view3DAspectRatio;
            this.view3DAspectRatio = f;
            this.propertyChangeSupport.firePropertyChange(Property.ASPECT_RATIO.name(), Float.valueOf(f2), Float.valueOf(f));
            if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                this.setHeight(Math.round((float)this.width / this.view3DAspectRatio), false);
            }
        }
    }

    public float get3DViewAspectRatio() {
        return this.view3DAspectRatio;
    }

    public View get3DView() {
        return this.view3D;
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    private static class HomeEnvironmentChangeListener
    implements PropertyChangeListener {
        private WeakReference<PhotoController> photoController;

        public HomeEnvironmentChangeListener(PhotoController photoController) {
            this.photoController = new WeakReference<PhotoController>(photoController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotoController photoController = (PhotoController)this.photoController.get();
            if (photoController == null) {
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, this);
            } else if (propertyChangeEvent.getPropertyName().equals(Camera.Property.LENS.name()) || propertyChangeEvent.getPropertyName().equals(Camera.Property.TIME.name())) {
                photoController.updateProperties();
            }
        }
    }

    private static class CameraChangeListener
    implements PropertyChangeListener {
        private WeakReference<PhotoController> photoController;

        public CameraChangeListener(PhotoController photoController) {
            this.photoController = new WeakReference<PhotoController>(photoController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotoController photoController = (PhotoController)this.photoController.get();
            if (photoController == null) {
                ((Camera)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
            } else {
                photoController.updateProperties();
            }
        }
    }

    private static class HomeCameraChangeListener
    implements PropertyChangeListener {
        private WeakReference<PhotoController> photoController;

        public HomeCameraChangeListener(PhotoController photoController) {
            this.photoController = new WeakReference<PhotoController>(photoController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotoController photoController = (PhotoController)this.photoController.get();
            if (photoController == null) {
                ((Home)propertyChangeEvent.getSource()).removePropertyChangeListener(Home.Property.CAMERA, this);
            } else {
                ((Camera)propertyChangeEvent.getOldValue()).removePropertyChangeListener(photoController.cameraChangeListener);
                photoController.updateProperties();
                ((Camera)propertyChangeEvent.getNewValue()).addPropertyChangeListener(photoController.cameraChangeListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ASPECT_RATIO,
        WIDTH,
        HEIGHT,
        QUALITY,
        VIEW_3D_ASPECT_RATIO,
        TIME,
        LENS,
        CEILING_LIGHT_COLOR;

    }
}

