/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class WallController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private TextureChoiceController leftSideTextureController;
    private TextureChoiceController rightSideTextureController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView wallView;
    private boolean editablePoints;
    private Float xStart;
    private Float yStart;
    private Float xEnd;
    private Float yEnd;
    private Float length;
    private Float distanceToEndPoint;
    private Integer leftSideColor;
    private WallPaint leftSidePaint;
    private Float leftSideShininess;
    private Integer rightSideColor;
    private WallPaint rightSidePaint;
    private Float rightSideShininess;
    private WallShape shape;
    private Float rectangularWallHeight;
    private Float slopingWallHeightAtStart;
    private Float sloppingWallHeightAtEnd;
    private Float thickness;
    private Float arcExtentInDegrees;

    public WallController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getLeftSideTextureController() {
        if (this.leftSideTextureController == null) {
            this.leftSideTextureController = new TextureChoiceController(this.preferences.getLocalizedString(WallController.class, "leftSideTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.leftSideTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WallController.this.setLeftSidePaint(WallPaint.TEXTURED);
                }
            });
        }
        return this.leftSideTextureController;
    }

    public TextureChoiceController getRightSideTextureController() {
        if (this.rightSideTextureController == null) {
            this.rightSideTextureController = new TextureChoiceController(this.preferences.getLocalizedString(WallController.class, "rightSideTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.rightSideTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WallController.this.setRightSidePaint(WallPaint.TEXTURED);
                }
            });
        }
        return this.rightSideTextureController;
    }

    public DialogView getView() {
        if (this.wallView == null) {
            this.wallView = this.viewFactory.createWallView(this.preferences, this);
        }
        return this.wallView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<Wall> list = Home.getWallsSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setXStart(null);
            this.setYStart(null);
            this.setXEnd(null);
            this.setYEnd(null);
            this.setEditablePoints(false);
            this.setLeftSideColor(null);
            this.getLeftSideTextureController().setTexture(null);
            this.setLeftSidePaint(null);
            this.setLeftSideShininess(null);
            this.setRightSideColor(null);
            this.getRightSideTextureController().setTexture(null);
            this.setRightSidePaint(null);
            this.setRightSideShininess(null);
            this.setRectangularWallHeight(null);
            this.setSlopingWallHeightAtStart(null);
            this.setSlopingWallHeightAtEnd(null);
            this.setShape(null);
            this.setThickness(null);
            this.setArcExtentInDegrees(null);
        } else {
            Wall wall = list.get(0);
            boolean bl = list.size() > 1;
            this.setEditablePoints(!bl);
            Float f = Float.valueOf(wall.getXStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f.equals(Float.valueOf(list.get(i).getXStart()))) continue;
                f = null;
                break;
            }
            this.setXStart(f);
            Float f2 = Float.valueOf(wall.getYStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.equals(Float.valueOf(list.get(i).getYStart()))) continue;
                f2 = null;
                break;
            }
            this.setYStart(f2);
            Float f3 = Float.valueOf(wall.getXEnd());
            for (int i = 1; i < list.size(); ++i) {
                if (f3.equals(Float.valueOf(list.get(i).getXEnd()))) continue;
                f3 = null;
                break;
            }
            this.setXEnd(f3);
            Float f4 = Float.valueOf(wall.getYEnd());
            for (int i = 1; i < list.size(); ++i) {
                if (f4.equals(Float.valueOf(list.get(i).getYEnd()))) continue;
                f4 = null;
                break;
            }
            this.setYEnd(f4);
            Integer n = wall.getLeftSideColor();
            if (n != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n.equals(list.get(i).getLeftSideColor())) continue;
                    n = null;
                    break;
                }
            }
            this.setLeftSideColor(n);
            HomeTexture homeTexture = wall.getLeftSideTexture();
            if (homeTexture != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (homeTexture.equals(list.get(i).getLeftSideTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            this.getLeftSideTextureController().setTexture(homeTexture);
            if (n != null) {
                this.setLeftSidePaint(WallPaint.COLORED);
            } else if (homeTexture != null) {
                this.setLeftSidePaint(WallPaint.TEXTURED);
            } else {
                this.setLeftSidePaint(null);
            }
            Float f5 = Float.valueOf(wall.getLeftSideShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f5.equals(Float.valueOf(list.get(i).getLeftSideShininess()))) continue;
                f5 = null;
                break;
            }
            this.setLeftSideShininess(f5);
            Integer n2 = wall.getRightSideColor();
            if (n2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n2.equals(list.get(i).getRightSideColor())) continue;
                    n2 = null;
                    break;
                }
            }
            this.setRightSideColor(n2);
            HomeTexture homeTexture2 = wall.getRightSideTexture();
            if (homeTexture2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (homeTexture2.equals(list.get(i).getRightSideTexture())) continue;
                    homeTexture2 = null;
                    break;
                }
            }
            this.getRightSideTextureController().setTexture(homeTexture2);
            if (n2 != null) {
                this.setRightSidePaint(WallPaint.COLORED);
            } else if (homeTexture2 != null) {
                this.setRightSidePaint(WallPaint.TEXTURED);
            } else {
                this.setRightSidePaint(null);
            }
            Float f6 = Float.valueOf(wall.getRightSideShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f6.equals(Float.valueOf(list.get(i).getRightSideShininess()))) continue;
                f6 = null;
                break;
            }
            this.setRightSideShininess(f6);
            Float f7 = wall.getHeight();
            if (f7 == null && wall.getHeight() == null) {
                f7 = Float.valueOf(this.home.getWallHeight());
            }
            for (int i = 1; i < list.size(); ++i) {
                float f8;
                Wall wall2 = list.get(i);
                float f9 = f8 = wall2.getHeight() == null ? this.home.getWallHeight() : wall2.getHeight().floatValue();
                if (f7.floatValue() == f8) continue;
                f7 = null;
                break;
            }
            this.setRectangularWallHeight(f7);
            this.setSlopingWallHeightAtStart(f7);
            Float f10 = wall.getHeightAtEnd();
            if (f10 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (f10.equals(list.get(i).getHeightAtEnd())) continue;
                    f10 = null;
                    break;
                }
            }
            this.setSlopingWallHeightAtEnd(f10 == null && list.size() == 1 ? f7 : f10);
            boolean bl2 = !wall.isTrapezoidal();
            boolean bl3 = wall.isTrapezoidal();
            for (int i = 1; i < list.size(); ++i) {
                if (!list.get(i).isTrapezoidal()) {
                    bl3 = false;
                    continue;
                }
                bl2 = false;
            }
            if (bl2) {
                this.setShape(WallShape.RECTANGULAR_WALL);
            } else if (bl3) {
                this.setShape(WallShape.SLOPING_WALL);
            } else {
                this.setShape(null);
            }
            Float f11 = Float.valueOf(wall.getThickness());
            for (int i = 1; i < list.size(); ++i) {
                if (f11.floatValue() == list.get(i).getThickness()) continue;
                f11 = null;
                break;
            }
            this.setThickness(f11);
            Float f12 = wall.getArcExtent();
            if (f12 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (f12.equals(list.get(i).getArcExtent())) continue;
                    f12 = null;
                    break;
                }
            }
            if (f12 != null) {
                this.setArcExtentInDegrees(Float.valueOf((float)Math.toDegrees(f12.floatValue())));
            } else {
                this.setArcExtentInDegrees(list.size() == 1 ? new Float(0.0f) : null);
            }
        }
    }

    public void setXStart(Float f) {
        if (f != this.xStart) {
            Float f2 = this.xStart;
            this.xStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_START.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getXStart() {
        return this.xStart;
    }

    public void setYStart(Float f) {
        if (f != this.yStart) {
            Float f2 = this.yStart;
            this.yStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y_START.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getYStart() {
        return this.yStart;
    }

    public void setXEnd(Float f) {
        if (f != this.xEnd) {
            Float f2 = this.xEnd;
            this.xEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_END.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getXEnd() {
        return this.xEnd;
    }

    public void setYEnd(Float f) {
        if (f != this.yEnd) {
            Float f2 = this.yEnd;
            this.yEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y_END.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getYEnd() {
        return this.yEnd;
    }

    private void updateLength() {
        Float f = this.getXStart();
        Float f2 = this.getYStart();
        Float f3 = this.getXEnd();
        Float f4 = this.getYEnd();
        if (f != null && f2 != null && f3 != null && f4 != null) {
            Wall wall = new Wall(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue(), 0.0f);
            Float f5 = this.getArcExtentInDegrees();
            if (f5 != null) {
                wall.setArcExtent(Float.valueOf((float)Math.toRadians(f5.floatValue())));
            }
            this.setLength(Float.valueOf(wall.getLength()), false);
        } else {
            this.setLength(null, false);
        }
    }

    public void setLength(Float f) {
        this.setLength(f, true);
    }

    public Float getLength() {
        return this.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setLength(Float f, boolean bl) {
        if (f == this.length) return;
        Float f2 = this.length;
        this.length = f;
        this.propertyChangeSupport.firePropertyChange(Property.LENGTH.name(), f2, f);
        if (!bl) return;
        Float f3 = this.getXStart();
        Float f4 = this.getYStart();
        Float f5 = this.getXEnd();
        Float f6 = this.getYEnd();
        if (f3 != null && f4 != null && f5 != null && f6 != null && f != null) {
            if (this.getArcExtentInDegrees() == null || this.getArcExtentInDegrees().floatValue() != 0.0f) throw new UnsupportedOperationException("Computing end point of a round wall from its length not supported");
            double d = Math.atan2(f4.floatValue() - f6.floatValue(), f5.floatValue() - f3.floatValue());
            this.setXEnd(Float.valueOf((float)((double)f3.floatValue() + (double)f.floatValue() * Math.cos(d))));
            this.setYEnd(Float.valueOf((float)((double)f4.floatValue() - (double)f.floatValue() * Math.sin(d))));
            return;
        } else {
            this.setXEnd(null);
            this.setYEnd(null);
        }
    }

    private void updateDistanceToEndPoint() {
        Float f = this.getXStart();
        Float f2 = this.getYStart();
        Float f3 = this.getXEnd();
        Float f4 = this.getYEnd();
        if (f != null && f2 != null && f3 != null && f4 != null) {
            this.setDistanceToEndPoint(Float.valueOf((float)Point2D.distance(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue())), false);
        } else {
            this.setDistanceToEndPoint(null, false);
        }
    }

    public void setDistanceToEndPoint(Float f) {
        this.setDistanceToEndPoint(f, true);
    }

    private void setDistanceToEndPoint(Float f, boolean bl) {
        if (f != this.distanceToEndPoint) {
            Float f2 = this.distanceToEndPoint;
            this.distanceToEndPoint = f;
            this.propertyChangeSupport.firePropertyChange(Property.DISTANCE_TO_END_POINT.name(), f2, f);
            if (bl) {
                Float f3 = this.getXStart();
                Float f4 = this.getYStart();
                Float f5 = this.getXEnd();
                Float f6 = this.getYEnd();
                if (f3 != null && f4 != null && f5 != null && f6 != null && f != null) {
                    double d = Math.atan2(f4.floatValue() - f6.floatValue(), f5.floatValue() - f3.floatValue());
                    this.setXEnd(Float.valueOf((float)((double)f3.floatValue() + (double)f.floatValue() * Math.cos(d))));
                    this.setYEnd(Float.valueOf((float)((double)f4.floatValue() - (double)f.floatValue() * Math.sin(d))));
                } else {
                    this.setXEnd(null);
                    this.setYEnd(null);
                }
            }
        }
    }

    public Float getDistanceToEndPoint() {
        return this.distanceToEndPoint;
    }

    public void setEditablePoints(boolean bl) {
        if (bl != this.editablePoints) {
            this.editablePoints = bl;
            this.propertyChangeSupport.firePropertyChange(Property.EDITABLE_POINTS.name(), !bl, bl);
        }
    }

    public boolean isEditablePoints() {
        return this.editablePoints;
    }

    public void setLeftSideColor(Integer n) {
        if (n != this.leftSideColor) {
            Integer n2 = this.leftSideColor;
            this.leftSideColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_COLOR.name(), n2, n);
            this.setLeftSidePaint(WallPaint.COLORED);
        }
    }

    public Integer getLeftSideColor() {
        return this.leftSideColor;
    }

    public void setLeftSidePaint(WallPaint wallPaint) {
        if (wallPaint != this.leftSidePaint) {
            WallPaint wallPaint2 = this.leftSidePaint;
            this.leftSidePaint = wallPaint;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_PAINT.name(), (Object)wallPaint2, (Object)wallPaint);
        }
    }

    public WallPaint getLeftSidePaint() {
        return this.leftSidePaint;
    }

    public void setLeftSideShininess(Float f) {
        if (f != this.leftSideShininess) {
            Float f2 = this.leftSideShininess;
            this.leftSideShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_SHININESS.name(), f2, f);
        }
    }

    public Float getLeftSideShininess() {
        return this.leftSideShininess;
    }

    public void setRightSideColor(Integer n) {
        if (n != this.rightSideColor) {
            Integer n2 = this.rightSideColor;
            this.rightSideColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_COLOR.name(), n2, n);
            this.setRightSidePaint(WallPaint.COLORED);
        }
    }

    public Integer getRightSideColor() {
        return this.rightSideColor;
    }

    public void setRightSidePaint(WallPaint wallPaint) {
        if (wallPaint != this.rightSidePaint) {
            WallPaint wallPaint2 = this.rightSidePaint;
            this.rightSidePaint = wallPaint;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_PAINT.name(), (Object)wallPaint2, (Object)wallPaint);
        }
    }

    public WallPaint getRightSidePaint() {
        return this.rightSidePaint;
    }

    public void setRightSideShininess(Float f) {
        if (f != this.rightSideShininess) {
            Float f2 = this.rightSideShininess;
            this.rightSideShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_SHININESS.name(), f2, f);
        }
    }

    public Float getRightSideShininess() {
        return this.rightSideShininess;
    }

    public void setShape(WallShape wallShape) {
        if (wallShape != this.shape) {
            WallShape wallShape2 = this.shape;
            this.shape = wallShape;
            this.propertyChangeSupport.firePropertyChange(Property.SHAPE.name(), (Object)wallShape2, (Object)wallShape);
        }
    }

    public WallShape getShape() {
        return this.shape;
    }

    public void setRectangularWallHeight(Float f) {
        if (f != this.rectangularWallHeight) {
            Float f2 = this.rectangularWallHeight;
            this.rectangularWallHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.RECTANGULAR_WALL_HEIGHT.name(), f2, f);
            this.setShape(WallShape.RECTANGULAR_WALL);
        }
    }

    public Float getRectangularWallHeight() {
        return this.rectangularWallHeight;
    }

    public void setSlopingWallHeightAtStart(Float f) {
        if (f != this.slopingWallHeightAtStart) {
            Float f2 = this.slopingWallHeightAtStart;
            this.slopingWallHeightAtStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.SLOPING_WALL_HEIGHT_AT_START.name(), f2, f);
            this.setShape(WallShape.SLOPING_WALL);
        }
    }

    public Float getSlopingWallHeightAtStart() {
        return this.slopingWallHeightAtStart;
    }

    public void setSlopingWallHeightAtEnd(Float f) {
        if (f != this.sloppingWallHeightAtEnd) {
            Float f2 = this.sloppingWallHeightAtEnd;
            this.sloppingWallHeightAtEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.SLOPING_WALL_HEIGHT_AT_END.name(), f2, f);
            this.setShape(WallShape.SLOPING_WALL);
        }
    }

    public Float getSlopingWallHeightAtEnd() {
        return this.sloppingWallHeightAtEnd;
    }

    public void setThickness(Float f) {
        if (f != this.thickness) {
            Float f2 = this.thickness;
            this.thickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.THICKNESS.name(), f2, f);
        }
    }

    public Float getThickness() {
        return this.thickness;
    }

    public void setArcExtentInDegrees(Float f) {
        if (f != this.arcExtentInDegrees) {
            Float f2 = this.arcExtentInDegrees;
            this.arcExtentInDegrees = f;
            this.propertyChangeSupport.firePropertyChange(Property.ARC_EXTENT_IN_DEGREES.name(), f2, f);
        }
    }

    public Float getArcExtentInDegrees() {
        return this.arcExtentInDegrees;
    }

    public void modifyWalls() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Wall> list2 = Home.getWallsSubList(list);
        if (!list2.isEmpty()) {
            Float f = this.getXStart();
            Float f2 = this.getYStart();
            Float f3 = this.getXEnd();
            Float f4 = this.getYEnd();
            Integer n = this.getLeftSidePaint() == WallPaint.COLORED ? this.getLeftSideColor() : null;
            HomeTexture homeTexture = this.getLeftSidePaint() == WallPaint.TEXTURED ? this.getLeftSideTextureController().getTexture() : null;
            Float f5 = this.getLeftSideShininess();
            Integer n2 = this.getRightSidePaint() == WallPaint.COLORED ? this.getRightSideColor() : null;
            HomeTexture homeTexture2 = this.getRightSidePaint() == WallPaint.TEXTURED ? this.getRightSideTextureController().getTexture() : null;
            Float f6 = this.getRightSideShininess();
            Float f7 = this.getThickness();
            Float f8 = this.getArcExtentInDegrees();
            if (f8 != null) {
                f8 = Float.valueOf((float)Math.toRadians(f8.floatValue()));
            }
            Float f9 = this.getShape() == WallShape.SLOPING_WALL ? this.getSlopingWallHeightAtStart() : (this.getShape() == WallShape.RECTANGULAR_WALL ? this.getRectangularWallHeight() : null);
            Float f10 = this.getShape() == WallShape.SLOPING_WALL ? this.getSlopingWallHeightAtEnd() : (this.getShape() == WallShape.RECTANGULAR_WALL ? this.getRectangularWallHeight() : null);
            ModifiedWall[] modifiedWallArray = new ModifiedWall[list2.size()];
            for (int i = 0; i < modifiedWallArray.length; ++i) {
                modifiedWallArray[i] = new ModifiedWall(list2.get(i));
            }
            WallController.doModifyWalls(modifiedWallArray, f, f2, f3, f4, n, homeTexture, f5, n2, homeTexture2, f6, f9, f10, f7, f8);
            if (this.undoSupport != null) {
                WallsModificationUndoableEdit wallsModificationUndoableEdit = new WallsModificationUndoableEdit(this.home, this.preferences, list, modifiedWallArray, f, f2, f3, f4, n, homeTexture, f5, n2, homeTexture2, f6, f9, f10, f7, f8);
                this.undoSupport.postEdit(wallsModificationUndoableEdit);
            }
        }
    }

    private static void doModifyWalls(ModifiedWall[] modifiedWallArray, Float f, Float f2, Float f3, Float f4, Integer n, HomeTexture homeTexture, Float f5, Integer n2, HomeTexture homeTexture2, Float f6, Float f7, Float f8, Float f9, Float f10) {
        for (ModifiedWall modifiedWall : modifiedWallArray) {
            Wall wall = modifiedWall.getWall();
            WallController.moveWallPoints(wall, f, f2, f3, f4);
            if (homeTexture != null) {
                wall.setLeftSideTexture(homeTexture);
                wall.setLeftSideColor(null);
            } else if (n != null) {
                wall.setLeftSideColor(n);
                wall.setLeftSideTexture(null);
            }
            if (f5 != null) {
                wall.setLeftSideShininess(f5.floatValue());
            }
            if (homeTexture2 != null) {
                wall.setRightSideTexture(homeTexture2);
                wall.setRightSideColor(null);
            } else if (n2 != null) {
                wall.setRightSideColor(n2);
                wall.setRightSideTexture(null);
            }
            if (f6 != null) {
                wall.setRightSideShininess(f6.floatValue());
            }
            if (f7 != null) {
                wall.setHeight(f7);
                if (f8 != null) {
                    if (f8.equals(f7)) {
                        wall.setHeightAtEnd(null);
                    } else {
                        wall.setHeightAtEnd(f8);
                    }
                }
            }
            if (f9 != null) {
                wall.setThickness(f9.floatValue());
            }
            if (f10 == null) continue;
            if (f10.floatValue() == 0.0f) {
                wall.setArcExtent(null);
                continue;
            }
            wall.setArcExtent(f10);
        }
    }

    private static void undoModifyWalls(ModifiedWall[] modifiedWallArray) {
        for (ModifiedWall modifiedWall : modifiedWallArray) {
            Wall wall = modifiedWall.getWall();
            WallController.moveWallPoints(wall, Float.valueOf(modifiedWall.getXStart()), Float.valueOf(modifiedWall.getYStart()), Float.valueOf(modifiedWall.getXEnd()), Float.valueOf(modifiedWall.getYEnd()));
            wall.setLeftSideColor(modifiedWall.getLeftSideColor());
            wall.setLeftSideTexture(modifiedWall.getLeftSideTexture());
            wall.setLeftSideShininess(modifiedWall.getLeftSideShininess());
            wall.setRightSideColor(modifiedWall.getRightSideColor());
            wall.setRightSideTexture(modifiedWall.getRightSideTexture());
            wall.setRightSideShininess(modifiedWall.getRightSideShininess());
            wall.setHeight(modifiedWall.getHeight());
            wall.setHeightAtEnd(modifiedWall.getHeightAtEnd());
            wall.setThickness(modifiedWall.getThickness());
            wall.setArcExtent(modifiedWall.getArcExtent());
        }
    }

    private static void moveWallPoints(Wall wall, Float f, Float f2, Float f3, Float f4) {
        Wall wall2 = wall.getWallAtStart();
        if (f != null) {
            wall.setXStart(f.floatValue());
            if (wall2 != null) {
                if (wall2.getWallAtStart() == wall) {
                    wall2.setXStart(f.floatValue());
                } else if (wall2.getWallAtEnd() == wall) {
                    wall2.setXEnd(f.floatValue());
                }
            }
        }
        if (f2 != null) {
            wall.setYStart(f2.floatValue());
            if (wall2 != null) {
                if (wall2.getWallAtStart() == wall) {
                    wall2.setYStart(f2.floatValue());
                } else if (wall2.getWallAtEnd() == wall) {
                    wall2.setYEnd(f2.floatValue());
                }
            }
        }
        Wall wall3 = wall.getWallAtEnd();
        if (f3 != null) {
            wall.setXEnd(f3.floatValue());
            if (wall3 != null) {
                if (wall3.getWallAtStart() == wall) {
                    wall3.setXStart(f3.floatValue());
                } else if (wall3.getWallAtEnd() == wall) {
                    wall3.setXEnd(f3.floatValue());
                }
            }
        }
        if (f4 != null) {
            wall.setYEnd(f4.floatValue());
            if (wall3 != null) {
                if (wall3.getWallAtStart() == wall) {
                    wall3.setYStart(f4.floatValue());
                } else if (wall3.getWallAtEnd() == wall) {
                    wall3.setYEnd(f4.floatValue());
                }
            }
        }
    }

    private static final class ModifiedWall {
        private final Wall wall;
        private final float xStart;
        private final float yStart;
        private final float xEnd;
        private final float yEnd;
        private final Integer leftSideColor;
        private final HomeTexture leftSideTexture;
        private final float leftSideShininess;
        private final Integer rightSideColor;
        private final HomeTexture rightSideTexture;
        private final float rightSideShininess;
        private final Float height;
        private final Float heightAtEnd;
        private final float thickness;
        private final Float arcExtent;

        public ModifiedWall(Wall wall) {
            this.wall = wall;
            this.xStart = wall.getXStart();
            this.yStart = wall.getYStart();
            this.xEnd = wall.getXEnd();
            this.yEnd = wall.getYEnd();
            this.leftSideColor = wall.getLeftSideColor();
            this.leftSideTexture = wall.getLeftSideTexture();
            this.leftSideShininess = wall.getLeftSideShininess();
            this.rightSideColor = wall.getRightSideColor();
            this.rightSideTexture = wall.getRightSideTexture();
            this.rightSideShininess = wall.getRightSideShininess();
            this.height = wall.getHeight();
            this.heightAtEnd = wall.getHeightAtEnd();
            this.thickness = wall.getThickness();
            this.arcExtent = wall.getArcExtent();
        }

        public Wall getWall() {
            return this.wall;
        }

        public float getXStart() {
            return this.xStart;
        }

        public float getXEnd() {
            return this.xEnd;
        }

        public float getYStart() {
            return this.yStart;
        }

        public float getYEnd() {
            return this.yEnd;
        }

        public Float getHeight() {
            return this.height;
        }

        public Float getHeightAtEnd() {
            return this.heightAtEnd;
        }

        public Integer getLeftSideColor() {
            return this.leftSideColor;
        }

        public HomeTexture getLeftSideTexture() {
            return this.leftSideTexture;
        }

        public float getLeftSideShininess() {
            return this.leftSideShininess;
        }

        public Integer getRightSideColor() {
            return this.rightSideColor;
        }

        public HomeTexture getRightSideTexture() {
            return this.rightSideTexture;
        }

        public float getRightSideShininess() {
            return this.rightSideShininess;
        }

        public float getThickness() {
            return this.thickness;
        }

        public Float getArcExtent() {
            return this.arcExtent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WallsModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final ModifiedWall[] modifiedWalls;
        private final Float xStart;
        private final Float yStart;
        private final Float xEnd;
        private final Float yEnd;
        private final Integer leftSideColor;
        private final HomeTexture leftSideTexture;
        private final Float leftSideShininess;
        private final Integer rightSideColor;
        private final HomeTexture rightSideTexture;
        private final Float rightSideShininess;
        private final Float height;
        private final Float heightAtEnd;
        private final Float thickness;
        private final Float arcExtent;

        private WallsModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, ModifiedWall[] modifiedWallArray, Float f, Float f2, Float f3, Float f4, Integer n, HomeTexture homeTexture, Float f5, Integer n2, HomeTexture homeTexture2, Float f6, Float f7, Float f8, Float f9, Float f10) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.modifiedWalls = modifiedWallArray;
            this.xStart = f;
            this.yStart = f2;
            this.xEnd = f3;
            this.yEnd = f4;
            this.leftSideColor = n;
            this.rightSideTexture = homeTexture2;
            this.leftSideShininess = f5;
            this.rightSideColor = n2;
            this.leftSideTexture = homeTexture;
            this.rightSideShininess = f6;
            this.height = f7;
            this.heightAtEnd = f8;
            this.thickness = f9;
            this.arcExtent = f10;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            WallController.undoModifyWalls(this.modifiedWalls);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            WallController.doModifyWalls(this.modifiedWalls, this.xStart, this.yStart, this.xEnd, this.yEnd, this.leftSideColor, this.leftSideTexture, this.leftSideShininess, this.rightSideColor, this.rightSideTexture, this.rightSideShininess, this.height, this.heightAtEnd, this.thickness, this.arcExtent);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(WallController.class, "undoModifyWallsName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WallPaint {
        COLORED,
        TEXTURED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WallShape {
        RECTANGULAR_WALL,
        SLOPING_WALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        X_START,
        Y_START,
        X_END,
        Y_END,
        LENGTH,
        DISTANCE_TO_END_POINT,
        EDITABLE_POINTS,
        LEFT_SIDE_COLOR,
        LEFT_SIDE_PAINT,
        RIGHT_SIDE_COLOR,
        RIGHT_SIDE_PAINT,
        SHAPE,
        RECTANGULAR_WALL_HEIGHT,
        SLOPING_WALL_HEIGHT_AT_START,
        SLOPING_WALL_HEIGHT_AT_END,
        THICKNESS,
        ARC_EXTENT_IN_DEGREES,
        LEFT_SIDE_SHININESS,
        RIGHT_SIDE_SHININESS;

    }
}

