/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.modifiers;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Modifier;
import org.sunflow.core.ParameterList;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.math.OrthoNormalBasis;

public class NormalMapModifier
implements Modifier {
    private Texture normalMap = null;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        String string = parameterList.getString("texture", null);
        if (string != null) {
            this.normalMap = sunflowAPI.getTextureCache().getTexture(sunflowAPI.resolveTextureFilename(string), true);
        }
        return this.normalMap != null;
    }

    public void modify(ShadingState shadingState) {
        shadingState.getNormal().set(this.normalMap.getNormal(shadingState.getUV().x, shadingState.getUV().y, shadingState.getBasis()));
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }
}

